<?php
/**
 * PrestaPay - A Sample Payment Module for PrestaShop 1.7
 *  
 * Order Validation Controller
 *
 * @author Andresa Martins <contact@andresa.dev>
 * @copyright  2007-2020 PrestaShop SA
 * @license http://opensource.org/licenses/afl-3.0.php
 */

include_once(_PS_MODULE_DIR_.'mtnpaycmr/mtnpaycmr.php');
//require_once(dirname(__FILE__) . '/../../config/config.inc.php');
class MtnPayCMRValidationModuleFrontController extends ModuleFrontController
{


    /**
     * Processa os dados enviados pelo formulário de pagamento
     */
    public function postProcess()
    {
        
        $sub2=Configuration::get('PAY_CMR_MOMO_SUBSCRIPTION_KEY');//subscription_key
        $token2=Configuration::get('PAY_CMR_MOMO_TOKEN');//token en cours
        $url2=Configuration::get('PAY_CMR_MOMO_CONSUMER_URL');
        $env2=Configuration::get('PAY_CMR_MOMO_ENVIRONNEMENT');
        /**
         * Get current cart object from session
         */
        $cart = $this->context->cart;
        $currency = $this->context->currency;
        $authorized = false;
        $mtnmobile=new MtnPayCMR();

        /**
         * Verify if this module is enabled and if the cart has
         * a valid customer, delivery address and invoice address
         */
        if (!$this->module->active || $cart->id_customer == 0 || $cart->id_address_delivery == 0
            || $cart->id_address_invoice == 0) {
            Tools::redirect('index.php?controller=order&step=1');
        }

        /**
         * Verify if this payment module is authorized
         */
        foreach (Module::getPaymentModules() as $module) {
            if ($module['name'] == 'mtnpaycmr') {
                $authorized = true;
                break;
            }
        }

        if (!$authorized) {
            die($this->l('This payment method is not available.'));
        }

        /** @var CustomerCore $customer */
        $customer = new Customer($cart->id_customer);

        /**
         * Check if this is a vlaid customer account
         */
        if (!Validate::isLoadedObject($customer)) {
            Tools::redirect('index.php?controller=order&step=1');
        }

        $total = (float)$cart->getOrderTotal(true, Cart::BOTH);
        //check mtn mobile money number
        //if (!preg_match("(^6[7]\d{7}$|^6[5][01234]\d{6}$|^6[8]\d{7}$)", $_REQUEST["ab_phone"]))
            //Tools::redirect('index.php?controller=order&step=3');

        $production=Configuration::get('PAY_CMR_MOMO_PRODUCTION_MODE');
        $subscription_key = trim(Configuration::get('PAY_CMR_MOMO_SUBSCRIPTION_KEY'));
        $this->ablog('subscription key: '.$subscription_key,'INFO');
        $api_user = trim(Configuration::get('PAY_CMR_MOMO_API_USER'));
        $this->ablog('Api user: '.$api_user,'INFO');
        $api_key = trim(Configuration::get('PAY_CMR_MOMO_API_KEY'));
        $this->ablog('Api key: '.$api_key,'INFO');
        $ab_message = Configuration::get('PAY_CMR_MOMO_PAYER_MESSAGE');
        $ab_note= Configuration::get('PAY_CMR_MOMO_PAYEE_NOTE');
        $phone = trim($_REQUEST["ab_phone"]);
        $currencyname=$mtnmobile->CurrencyName;
        $this->ablog('currency: '.$currencyname,'INFO');
        $url=$mtnmobile->urlName;
        $this->ablog('url: '.$url,'INFO');
        //$Environment=$mtnmobile->Environment;
        $Environment=Configuration::get('PAY_CMR_MOMO_ENVIRONNEMENT');
        $this->ablog('Environment: '.$Environment,'INFO');

        //api_user
        /*if ($production==0 || $production=='0') {
            $api_user = $mtnmobile->guidv4();
            $api_usercode=$this->setRequestAPIUSER($subscription_key, $api_user, $url);
            $this->ablog('api user code: '.$api_usercode,'INFO');
            if ($api_usercode=='201' || $api_usercode==201) {
                $api_key=$this->setRequestAPIKEY($subscription_key, $api_user, $url);
                $this->ablog('new Api key: '.$api_key,'INFO');
                if ($api_key=="ERROR") {
                    $this->ablog('Error generation api_key:','INFO');
                }
            }
        }*/


        $credentials=base64_encode($api_user.":".$api_key);
        $this->ablog('credentials: '.$credentials,'INFO');
        $token=$this->setRequestToken($subscription_key, $credentials, $url);

        $this->ablog('token: '.$token,'INFO');

        $result = json_decode($token, true);
        $resultToken="";
        if(isset($result["access_token"]) && $api_key!="ERROR")
        {
          $this->ablog('Token success: '.$result["access_token"],'INFO');
          $resultToken=$result["access_token"];
          Configuration::updateValue('PAY_CMR_MOMO_TOKEN', $resultToken);

        }
        elseif(isset($result["error"]))
        {
            $this->ablog('Token error: '.$token,'INFO');
        }
        else
        {
            $token=$this->setRequestToken($subscription_key, $credentials, $url);
            $result=json_decode($token, true);
            if(isset($result["access_token"]))
            {
              $this->ablog('Token regenerate success: '.$result["access_token"],'INFO');
              $resultToken=$result["access_token"];
              Configuration::updateValue('PAY_CMR_MOMO_TOKEN', $resultToken);
            }
        }

        //information sur la commande
        $amount = $total+0; //remove zeros decimal
        $amount = ceil($amount); //round to next int value

        $this->ablog('API Url '.$url,'INFO');
        if ($resultToken!="") {
            /**
             * Place the order
             */
            //$this->module->validateOrder((int)$cart->id, Configuration::get('PS_OS_PAYMENT'), $total, $this->module->displayName, NULL,NULL, (int)$currency->id, false, $customer->secure_key);

            $this->ablog('Validation de la commande '.$this->module->currentOrder.' ==> Initiation du processus de paiement', 'INFO');
            $uuid = static::uuid();
            /**
             * Call API PAYMENT MTN
             */
            $header = $this->setRequestHeader($resultToken, $uuid, $Environment, $subscription_key);
            $this->ablog('Id order: '.$this->module->currentOrder, 'INFO');

            $data = array("amount" => $amount,"currency" => $currencyname,"externalId" => $uuid,"payer" => array("partyIdType" => "MSISDN", "partyId" => "237".$phone),"payerMessage" => $ab_message, "payeeNote" => $ab_note);
            $data_string = json_encode($data);
            $this->ablog('Data Header: '.json_encode($header), 'INFO');
            $this->ablog('Data payment: '.$data_string, 'INFO');

            $ch = curl_init();
            curl_setopt($ch, CURLOPT_URL, $url."collection/v1_0/requesttopay");
            curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);
            curl_setopt($ch, CURLOPT_POST, true);
            curl_setopt($ch, CURLOPT_SSL_VERIFYPEER, false);
            curl_setopt($ch, CURLOPT_POSTFIELDS, $data_string);
            curl_setopt($ch, CURLOPT_HTTPHEADER, $header);
            $response = curl_exec($ch);
            $httpcode = curl_getinfo($ch, CURLINFO_HTTP_CODE);
            curl_close($ch);
            $this->ablog('data in function '.$httpcode, 'INFO');
            if ($httpcode == 202 || $httpcode=='202') {

                // validate order
                $this->module->validateOrder(
                    (int) $cart->id,
                    Configuration::get('PS_OS_PAYMENT'),
                    $amount,
                    $this->module->displayName,
                    null,
                    null,
                    (int) $currency->id,
                    false,
                    $customer->secure_key
                );
                $this->ablog('retour du web service pour la commande: '.$this->module->currentOrder.' ==> '.$httpcode, 'INFO');
                //update the order state
                $history = new OrderHistory();
                $history->id_order = $this->module->currentOrder;
                //$history->changeIdOrderState(2,$this->module->currentOrder);
                $history->changeIdOrderState(3, $this->module->currentOrder);//mettre en statut 3=>En cours de préaparation
                Db::getInstance()->update('order_history', array('id_order_state' => 3), 'id_order='.$this->module->currentOrder, 1, false, true, true);
                $sqlre = 'INSERT INTO `' . _DB_PREFIX_ . 'MTN_MOBILE_MONEY`
                            SET `id_order` = ' . pSQL((int) $this->module->currentOrder) .',
                            `reference_id` ="'. pSQL($uuid).'"';
                Db::getInstance()->execute($sqlre);
                sleep(25);
                $header=array();
                $header[]="Authorization:Bearer ".$resultToken;
                $header[]="X-Target-Environment:".$Environment;
                $header[]="Ocp-Apim-Subscription-Key:".$subscription_key;
                $ch2 = curl_init();
                curl_setopt($ch2, CURLOPT_URL, $url."collection/v1_0/requesttopay/".$uuid);
                curl_setopt($ch2, CURLOPT_RETURNTRANSFER, true);
                curl_setopt($ch2, CURLOPT_HTTPHEADER, $header);
                $response2 = curl_exec($ch2);
                $httpcode2 = curl_getinfo($ch2, CURLINFO_HTTP_CODE);
                curl_close($ch2);
                $this->ablog('data in function 2'.$response2, 'INFO');
                $this->ablog('data in function 2'.$httpcode2, 'INFO');
                $rep2=json_decode($response2, true);
                if ($httpcode2==200 || $httpcode2=='200') {
                        
                    //Mise à jours statut
                    $sqlre =
                    'UPDATE `'._DB_PREFIX_.'mtn_mobile_money` 
                        SET `order_statut` = "' . pSQL($rep2['status']) . '" WHERE `' .
                        _DB_PREFIX_ . 'mtn_mobile_money`.`id_order` = ' . pSQL((int) $result['id_order']);
                    Db::getInstance()->execute($sqlre);
                    //$rep2['status'];
                    //print_r($rep2['status']);
                    $this->ablog('status paiement', $rep2['status']);
                    if ($rep2['status']=="SUCCESSFUL") {
                        $history->changeIdOrderState(2, $this->module->currentOrder);//mettre en statut 3=>En cours de préaparation
                        Db::getInstance()->update('order_history', array('id_order_state' => 2), 'id_order='.$this->module->currentOrder, 1, false, true, true);
                    } elseif ($rep2['status']=="FAILED") {
                        $history->changeIdOrderState(8, $this->module->currentOrder);//mettre en statut 3=>En cours de préaparation
                        Db::getInstance()->update('order_history', array('id_order_state' => 8), 'id_order='.$this->module->currentOrder, 1, false, true, true);
                    }
                    /**
                     * Redirect the customer to the order confirmation page
                     */
                    Tools::redirect('index.php?controller=order-confirmation&id_cart='.(int)$cart->id.'&id_module='.(int)$this->module->id.'&id_order='.$this->module->currentOrder.'&key='.$customer->secure_key);
                } else {
                    $this->ablog('erreur fonctionnelle : '.$this->module->currentOrder.' ==> '.$httpcode, 'INFO');
                    Tools::redirect('index.php?controller=order&step=3&pay=0');
                }
            }
        }

    }
    

    /**
     * Sets the request header
     */
    public function setRequestHeader($token, $referenceID, $Environment, $subscription){

        $header=array();
        $header[]="Content-Type:application/json";
        $header[]="X-Target-Environment:".$Environment;
        $header[]="Ocp-Apim-Subscription-Key:".$subscription;
        $header[]="X-Reference-Id:".$referenceID;
        $header[]="Authorization:Bearer ".$token;

        return $header;
    }

    /**
     * Sets the request header
     */
    public function setRequestToken($subscription_key, $credentials, $url){

        $header=array();
        $header[]="Authorization:Basic ".$credentials;
        $header[]="Ocp-Apim-Subscription-Key:".$subscription_key;
        $urlf=$url."collection/token/";

        $ch = curl_init();
        curl_setopt($ch, CURLOPT_URL , $urlf);
        curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);
        curl_setopt($ch, CURLOPT_POST, true);
        curl_setopt($ch, CURLOPT_POSTFIELDS, array());
        curl_setopt($ch, CURLOPT_SSL_VERIFYPEER, false);
        curl_setopt($ch, CURLOPT_HTTPHEADER, $header);
        $token = curl_exec($ch);
        //$httpcode = curl_getinfo($ch, CURLINFO_HTTP_CODE);
        curl_close($ch);

        //$mtnmobile->writeInLogFile('httpcode '.$httpcode,'INFO');

        return $token;
    }

    public function setRequestAPIUSER($subscription_key, $api_user, $url){

        $data = array("providerCallbackHost" => "");
        $data_string = json_encode($data);
        $header=array();
        $header[]="X-Reference-Id:".$api_user;
        $header[]="Ocp-Apim-Subscription-Key:".$subscription_key;
        $header[]="Content-Type:application/json";
        $header[]="Content-Length:".Tools::strlen($data_string);
        $urlf=$url."v1_0/apiuser";

        $ch = curl_init();
        curl_setopt($ch, CURLOPT_URL , $urlf);
        curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);
        curl_setopt($ch, CURLOPT_POST, true);
        curl_setopt($ch, CURLOPT_POSTFIELDS, $data_string);
        curl_setopt($ch, CURLOPT_SSL_VERIFYPEER, false);
        curl_setopt($ch, CURLOPT_HTTPHEADER, $header);
        curl_exec($ch);
        $httpcode = curl_getinfo($ch, CURLINFO_HTTP_CODE);
        curl_close($ch);

        return $httpcode;
    }

    public function setRequestAPIKEY($subscription_key, $api_user, $url){

        $header=array();
        $header[]="Ocp-Apim-Subscription-Key:".$subscription_key;
        $urlf=$url."v1_0/apiuser/".$api_user."/apikey";

        $ch = curl_init();
        curl_setopt($ch, CURLOPT_URL , $urlf);
        curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);
        curl_setopt($ch, CURLOPT_POST, true);
        curl_setopt($ch, CURLOPT_POSTFIELDS, array());
        curl_setopt($ch, CURLOPT_SSL_VERIFYPEER, false);
        curl_setopt($ch, CURLOPT_HTTPHEADER, $header);
        $api = curl_exec($ch);
        $httpcode = curl_getinfo($ch, CURLINFO_HTTP_CODE);
        curl_close($ch);
        $result=json_decode($api, true);
        if ($httpcode=='201' || $httpcode==201) {
            return $result['apiKey'];
        }
        else
        {
            return "ERROR";
        }

    }

    public function ablog($data,$level){
        $day = gmdate("Y-m-d");
        $logfile=dirname(__FILE__).'/../../logs/mtnmobilemoneycmr_'.$day.'.log';
        error_log("\r\n".'['.gmdate("Y-m-d H:i:s").'] '.$level.' '.$data, 3, $logfile);
    }

    public static function uuid()
    {
        return sprintf(
            '%04x%04x-%04x-%04x-%04x-%04x%04x%04x',
            mt_rand(0, 0xffff),
            mt_rand(0, 0xffff),
            mt_rand(0, 0xffff),
            mt_rand(0, 0x0fff) | 0x4000,
            mt_rand(0, 0x3fff) | 0x8000,
            mt_rand(0, 0xffff),
            mt_rand(0, 0xffff),
            mt_rand(0, 0xffff)
        );
    }
}
