<?php
/**
 * PrestaPay - A Sample Payment Module for PrestaShop 1.7
 *
 * This file is the declaration of the module.
 *
 * @author Andresa Martins <contact@andresa.dev>
 * @copyright  2007-2020 PrestaShop SA
 * @license http://opensource.org/licenses/afl-3.0.php
 */

if (!defined('_PS_VERSION_')) {
    exit;
}

class MtnPayCMR extends PaymentModule
{
    private $_html = '';
    private $_postErrors = array();

    public $subscriptionKey;
    public $apiUser;
    public $apiKey;
    public $payerMessage;
    public $payeeNote;
    public $productionMode;
    public $CurrencyName;
    public $Environment;
    public $urlName;

    /**
     * PrestaPay constructor.
     *
     * Set the information about this module
     */
    public function __construct()
    {
        $this->name                   = 'mtnpaycmr';
        $this->tab                    = 'payments_gateways';
        $this->version                = '1.2.1';
        $this->author                 = 'Abyster Consulting';
        $this->controllers            = array('payment', 'validation');
        $this->currencies             = true;
        $this->currencies_mode        = 'checkbox';
        $this->bootstrap              = true;
        $this->displayName = $this->l('Payer par MTN Mobile Money CMR');
        $this->description = $this->l('Accepts payments by MTN Mobile Money Cameroon.');
        $this->confirmUninstall = $this->l('Are you sure you want to delete your details ?');
        $this->ps_versions_compliancy = array('min' => '1.7.0', 'max' => _PS_VERSION_);
        //version du module et clé de production
        // $this->module_key = 'a48c2d2fdc3ab88ae83dd79ed72713c0';

        // chargement des parametres de base
        $this->subscriptionKey = Configuration::get('PAY_CMR_MOMO_SUBSCRIPTION_KEY');
        $this->apiKey = Configuration::get('PAY_CMR_MOMO_API_KEY');
        $this->apiUser = Configuration::get('PAY_CMR_MOMO_API_USER');
        $this->payerMessage = Configuration::get('PAY_CMR_MOMO_PAYER_MESSAGE');
        $this->payeeNote = Configuration::get('PAY_CMR_MOMO_PAYEE_NOTE');
        $this->productionMode = Configuration::get('PAY_CMR_MOMO_PRODUCTION_MODE');
        $this->CurrencyName=Configuration::get('PAY_CMR_MOMO_CURRENCY_NAME');
        $this->Environment=Configuration::get('PAY_CMR_MOMO_ENVIRONNEMENT');
        $this->urlName=Configuration::get('PAY_CMR_MOMO_CONSUMER_URL');

        parent::__construct();
    }

    /**
     * Install this module and register the following Hooks:
     *
     * @return bool
     */
    public function install()
    {
        if (!parent::install() ||
            !$this->registerHook('paymentOptions') ||
            !$this->registerHook('paymentReturn') ||
            !$this->addTable('add')) {
                return false;
            }
            
        Configuration::updateValue('PAY_CMR_MOMO_TOKEN', '');
        Configuration::updateValue('PAY_CMR_MOMO_SUBSCRIPTION_KEY', '');
        Configuration::updateValue('PAY_CMR_MOMO_API_KEY', '');
        Configuration::updateValue('PAY_CMR_MOMO_API_USER', '');
        Configuration::updateValue('PAY_CMR_MOMO_PAYER_MESSAGE', '');
        Configuration::updateValue('PAY_CMR_MOMO_PAYEE_NOTE', '');
        Configuration::updateValue('PAY_CMR_MOMO_PRODUCTION_MODE', 0);
        Configuration::updateValue('PAY_CMR_MOMO_CONSUMER_URL', 'https://sandbox.momodeveloper.mtn.com/');
        Configuration::updateValue('PAY_CMR_MOMO_CURRENCY_NAME', 'EUR');
        Configuration::updateValue('PAY_CMR_MOMO_ENVIRONNEMENT', 'sandbox');

        return true;

    }

    /**
     * Uninstall this module and remove it from all hooks
     *
     * @return bool
     */
    public function uninstall()
    {
        if (!parent::uninstall())
            return false;

        /* Clean configuration table */
        
        Configuration::deleteByName('PAY_CMR_MOMO_TOKEN');
        Configuration::deleteByName('PAY_CMR_MOMO_SUBSCRIPTION_KEY');
        Configuration::deleteByName('PAY_CMR_MOMO_CONSUMER_URL');
        Configuration::deleteByName('PAY_CMR_MOMO_API_KEY');
        Configuration::deleteByName('PAY_CMR_MOMO_API_USER');
        Configuration::deleteByName('PAY_CMR_MOMO_PAYER_MESSAGE');
        Configuration::deleteByName('PAY_CMR_MOMO_PAYEE_NOTE');
        Configuration::deleteByName('PAY_CMR_MOMO_PRODUCTION_MODE');
        Configuration::deleteByName('PAY_CMR_MOMO_ENVIRONNEMENT');
        Configuration::deleteByName('PAY_CMR_MOMO_CURRENCY_NAME');

        return true;
    }

    public function addTable($method)
    {
        
        switch ($method) {
            case 'add':
                $sql = "CREATE TABLE IF NOT EXISTS `" . _DB_PREFIX_ . "MTN_MOBILE_MONEY`(
                `id_tablename` INT(11) NOT NULL AUTO_INCREMENT PRIMARY KEY ,
                `id_order` int(10) unsigned NOT NULL,
                 `reference_id` varchar(200) DEFAULT NULL,
                `order_statut` varchar(64) DEFAULT NULL)";
                break;
        }
        if (!Db::getInstance()->Execute($sql)) {
            return false;
        }
        return true;
    }

    private function _postValidation()
    {
        if (Tools::isSubmit('btnSubmit'))
        {
            if (!Tools::getValue('payer_message') ||
                !Tools::getValue('subscription_key') ||
                !Tools::getValue('environment') ||
                !Tools::getValue('payee_note') ||
                !Tools::getValue('auth_user') ||
                !Tools::getValue('auth_header')
               )
                $this->_postErrors[] = $this->l('please fill in the required fields');
        }
    }

    private function _postProcess()
    {
        if (Tools::isSubmit('btnSubmit'))
        {
            Configuration::updateValue('PAY_CMR_MOMO_SUBSCRIPTION_KEY', Tools::getValue('subscription_key'));
            Configuration::updateValue('PAY_CMR_MOMO_ENVIRONNEMENT', Tools::getValue('environment'));
            Configuration::updateValue('PAY_CMR_MOMO_API_KEY', Tools::getValue('auth_header'));
            Configuration::updateValue('PAY_CMR_MOMO_API_USER', Tools::getValue('auth_user'));
            Configuration::updateValue('PAY_CMR_MOMO_PAYER_MESSAGE', Tools::getValue('payer_message'));
            Configuration::updateValue('PAY_CMR_MOMO_PAYEE_NOTE', Tools::getValue('payee_note'));
            Configuration::updateValue('PAY_CMR_MOMO_PRODUCTION_MODE', Tools::getValue('production_mode'));
            if (Configuration::get('PAY_CMR_MOMO_PRODUCTION_MODE')==0 || Configuration::get('PAY_CMR_MOMO_PRODUCTION_MODE')=='0') {
                Configuration::updateValue('PAY_CMR_MOMO_CURRENCY_NAME', 'EUR');
                Configuration::updateValue('PAY_CMR_MOMO_CONSUMER_URL', 'https://sandbox.momodeveloper.mtn.com/');
            }
            else if(Configuration::get('PAY_CMR_MOMO_PRODUCTION_MODE')==1 || Configuration::get('PAY_CMR_MOMO_PRODUCTION_MODE')=='1'){
                Configuration::updateValue('PAY_CMR_MOMO_CURRENCY_NAME', 'XAF');
                Configuration::updateValue('PAY_CMR_MOMO_CONSUMER_URL', 'https://proxy.momoapi.mtn.com/');
            }
        }
        $this->_html .= $this->displayConfirmation($this->l('Settings Successful updated'));
    }

    private function _displayMtnPayCMR()
    {
        $this->_html .= $this->display(__FILE__, 'info.tpl');
    }

    /**
     * Returns a string containing the HTML necessary to
     * generate a configuration screen on the admin
     *
     * @return string
     */
    public function getContent()
    {
        $this->_html = $this->l($this->displayName);

        if (Tools::isSubmit('btnSubmit'))
        {
            $this->_postValidation();
            if (!count($this->_postErrors))
                $this->_postProcess();
            else
                foreach ($this->_postErrors as $err)
                    $this->_html .= $this->displayError($err);
        }
            
        $this->_displayMtnPayCMR();
        $this->_html .= $this->renderForm();

        return $this->_html;
    }

    /**
     * Display this module as a payment option during the checkout
     *
     * @param array $params
     * @return array|void
     */
    public function hookPaymentOptions($params)
    {
        /*
         * Verify if this module is active
         */
        if (!$this->active) {
            return;
        }

        /**
         * Form action URL. The form data will be sent to the
         * validation controller when the user finishes
         * the order process.
         */
        $formAction = $this->context->link->getModuleLink($this->name, 'validation', array(), true);

        /**
         * Assign the url form action to the template var $action
         */
        $this->smarty->assign(['action' => $formAction]);

        /**
         *  Load form template to be displayed in the checkout step
         */
        $paymentForm = $this->fetch('module:mtnpaycmr/views/templates/hook/payment_options.tpl');

        /**
         * Create a PaymentOption object containing the necessary data
         * to display this module in the checkout
         */
        $newOption = new PrestaShop\PrestaShop\Core\Payment\PaymentOption;
        $newOption->setModuleName($this->displayName)
            ->setCallToActionText($this->displayName)
            ->setAction($formAction)
            ->setForm($paymentForm);

        $payment_options = array(
            $newOption
        );

        return $payment_options;
    }

    /**
     * Display a message in the paymentReturn hook
     * 
     * @param array $params
     * @return string
     */
    public function hookPaymentReturn($params)
    {
        /**
         * Verify if this module is enabled
         */
        if (!$this->active) {
            return;
        }

        $smarty = $this->context->smarty;
        $state = $params['order']->current_state;
        $currency = new Currency($params['order']->id_currency);
        $this->writeInLogFile($state, 'INFO');
        //if ($state == Configuration::get('PS_OS_PAYMENT'))
        if ($state == 3)
        {
            $smarty->assign(array(
                'total_to_pay' => Tools::displayPrice($params['order']->total_paid, $currency, false),
                'status' => 'ok',
                'id_order' => $params['order']->reference
            ));
            if (isset($params['order']->reference) && !empty($params['order']->reference))
                $smarty->assign('reference', $params['order']->reference);

        } else {
            $smarty->assign('status', 'failed');
        }
        
        return $this->context->smarty->fetch('module:mtnpaycmr/views/templates/hook/payment_return.tpl');
    }

    /**
     * Render config page form
     */
    public function renderForm()
    {
        $production_mode_options = array(
            array( 'id' => 'production_mode_on', 'value' => 1, 'label' => $this->l('Yes')),
            array( 'id' => 'production_mode_off', 'value' => 0, 'label' => $this->l('No')),
        );

        $fields_form = array(
            'form' => array(
                'legend' => array(
                    'title' => $this->l('Configuration'),
                    'icon' => 'icon-cog'
                ),
                'input' => array(
                    array(
                        'type' => 'text',
                        'label' => $this->l('Subscription key'),
                        'name' => 'subscription_key',
                        'required' => true
                    ),
                    array(
                        'type' => 'text',
                        'label' => $this->l('Api User'),
                        'name' => 'auth_user',
                        'required' => true
                    ),
                    array(
                        'type' => 'text',
                        'label' => $this->l('Api Key'),
                        'name' => 'auth_header',
                        'required' => true
                    ),
                    array(
                        'type' => 'text',
                        'label' => $this->l('Target Environment'),
                        'name' => 'environment',
                        'required' => true
                    ),
                    array(
                        'type' => 'textarea',
                        'label' => $this->l('Payer message'),
                        'name' => 'payer_message',
                        'rows' => '3',
                        'cols' => '53',
                        'required' => true
                    ),
                    array(
                        'type' => 'textarea',
                        'label' => $this->l('Payer note'),
                        'name' => 'payee_note',
                        'rows' => '3',
                        'cols' => '53',
                        'required' => true
                    ),
                    array(
                        'type' => 'switch',
                        'label' => $this->l('Enable Production Mode'),
                        'name' => 'production_mode',
                        'required' => false,
                        'is_bool' => true,
                        'values' => $production_mode_options
                    ),
                    array(
                        'type' => 'html',
                        'name' => 'html_data',
                        'html_content' => '<a href="' . _PS_BASE_URL_.__PS_BASE_URI__ 
                        . '/modules/mtnpaycmr/cron.php" target="_blank">Cron valid order</a> (Cron validation order status)'
                    )
                ),
                'submit' => array(
                    'title' => $this->l('Update settings'),
                )
            ),
        );

        $helper = new HelperForm();
        $helper->show_toolbar = false;
        $helper->table = $this->table;
        $lang = new Language((int)Configuration::get('PS_LANG_DEFAULT'));
        $helper->default_form_language = $lang->id;
        $helper->allow_employee_form_lang = Configuration::get('PS_BO_ALLOW_EMPLOYEE_FORM_LANG') ? Configuration::get('PS_BO_ALLOW_EMPLOYEE_FORM_LANG') : 0;
        $this->fields_form = array();
        $helper->id = (int)Tools::getValue('id_carrier');
        $helper->identifier = $this->identifier;
        $helper->submit_action = 'btnSubmit';
        $helper->currentIndex = $this->context->link->getAdminLink('AdminModules', false).'&configure='.$this->name.'&tab_module='.$this->tab.'&module_name='.$this->name;
        $helper->token = Tools::getAdminTokenLite('AdminModules');
        $helper->tpl_vars = array(
            'fields_value' => $this->getConfigFieldsValues(),
            'languages' => $this->context->controller->getLanguages(),
            'id_language' => $this->context->language->id
        );
        return $helper->generateForm(array($fields_form));
    }

    /**
     * Gets config fields values
     */
    public function getConfigFieldsValues()
    {
        return array(
            'subscription_key' => Tools::getValue('subscription_key', Configuration::get('PAY_CMR_MOMO_SUBSCRIPTION_KEY')),
            'auth_user' => Tools::getValue('auth_user', Configuration::get('PAY_CMR_MOMO_API_USER')),
            'auth_header' => Tools::getValue('auth_header', Configuration::get('PAY_CMR_MOMO_API_KEY')),
            'environment' => Tools::getValue('environment', Configuration::get('PAY_CMR_MOMO_ENVIRONNEMENT')),
            'payer_message' => Tools::getValue('payer_message', Configuration::get('PAY_CMR_MOMO_PAYER_MESSAGE')),
            'payee_note' => Tools::getValue('payee_note', Configuration::get('PAY_CMR_MOMO_PAYEE_NOTE')),
            'production_mode' => Tools::getValue('production_mode', Configuration::get('PAY_CMR_MOMO_PRODUCTION_MODE'))
        );
    }

    /**
     * Write in Log file
     */
    public function writeInLogFile($data,$level){
        $day = gmdate("Y-m-d");
        $logfile = _PS_MODULE_DIR_.'mtnpaycmr/logs/mtnmobilemoneycmr_'.$day.'.log';
        error_log("\r\n".'['.gmdate("Y-m-d H:i:s").'] '.$level.' '.$data, 3, $logfile);
    }

  public function guidv4()
  {
        return sprintf('%04x%04x-%04x-%04x-%04x-%04x%04x%04x',

          // 32 bits for "time_low"
          mt_rand(0, 0xffff), mt_rand(0, 0xffff),

          // 16 bits for "time_mid"
          mt_rand(0, 0xffff),

          // 16 bits for "time_hi_and_version",
          // four most significant bits holds version number 4
          mt_rand(0, 0x0fff) | 0x4000,

          // 16 bits, 8 bits for "clk_seq_hi_res",
          // 8 bits for "clk_seq_low",
          // two most significant bits holds zero and one for variant DCE1.1
          mt_rand(0, 0x3fff) | 0x8000,

          // 48 bits for "node"
          mt_rand(0, 0xffff), mt_rand(0, 0xffff), mt_rand(0, 0xffff)
        );
  }

}