<?php
/**
* 2007-2018 PrestaShop
*
* NOTICE OF LICENSE
*
* This source file is subject to the Academic Free License (AFL 3.0)
* that is bundled with this package in the file LICENSE.txt.
* It is also available through the world-wide-web at this URL:
* http://opensource.org/licenses/afl-3.0.php
* If you did not receive a copy of the license and are unable to
* obtain it through the world-wide-web, please send an email
* to license@prestashop.com so we can send you a copy immediately.
*
* DISCLAIMER
*
* Do not edit or add to this file if you wish to upgrade PrestaShop to newer
* versions in the future. If you wish to customize PrestaShop for your
* needs please refer to http://www.prestashop.com for more information.
*
*  @author PrestaShop SA <contact@prestashop.com>
*  @copyright  2007-2022 PrestaShop SA
*  @license    http://opensource.org/licenses/afl-3.0.php  Academic Free License (AFL 3.0)
*  International Registered Trademark & Property of PrestaShop SA
*/

include_once(_PS_MODULE_DIR_.'orangemoneycmr/classes/OrangeMoneyCmrPayment.php');

class OrangeMoneyCMRValidationModuleFrontController extends ModuleFrontController
{
    public function postProcess()
    {
		$cart = $this->context->cart;
		$currency = $this->context->currency;
		
		if ($cart->id_customer == 0 || $cart->id_address_delivery == 0 || $cart->id_address_invoice == 0 || !$this->module->active)
		    Tools::redirect('index.php?controller=order&step=1');
		
        // Check that this payment option is still available in case the customer changed his address just before the end of the checkout process
		$authorized = false;
		foreach (Module::getPaymentModules() as $module) {
            if ($module['name'] == 'orangemoneycmr') {
				$authorized = true;
				break;
			}
		}

		if (!$authorized)
		    die($this->module->l('This payment method is not available.', 'validation'));

		if ( empty($this->module->authHeader) || empty($this->module->merchantKey) || empty($this->module->merchantName)) {
			$this->module->writeInlogFile($this->module->l('Payment method error : empty parameter detected. Payment cancelled. '), 'ERROR');
			Tools::redirect('index.php?controller=order&step=1&erreur=We have a problem with this payment method. Please choose another one.');
		}

		if ( empty($this->module->accessToken)) {

			$token = OrangeMoneyCmrPayment::generateAccessToken($this->module);
			if (!$token) {
				$this->module->writeInlogFile($this->module->l('Payment method error : no access token provided and generating new one failed. Payment cancelled. '), 'ERROR');
				Tools::redirect('index.php?controller=order&step=1&erreur=We have a problem with this payment method. Please choose another one.');
			} else {
				Configuration::updateValue('AB_ACCESS_TOKEN', $token);
				$this->module->accessToken = $token;
			}
		}

		$customer = new Customer($cart->id_customer);
		
		if (!Validate::isLoadedObject($customer))
		    Tools::redirect('index.php?controller=order&step=1');
		
	    $customer_details = array(
			'customer_name' => Tools::getValue('name'),
			'customer_email' => Tools::getValue('email'),
			'customer_tel' => Tools::getValue('tel')
		);

		$this->module->validateOrder((int)$cart->id, Configuration::get('PS_OS_COD_VALIDATION'), (float)$cart->getOrderTotal(true, Cart::BOTH), $this->module->displayName, NULL,NULL, (int)$currency->id, false, $customer->secure_key);

		$order = new Order($this->module->currentOrder);

		$this->module->language = $this->context->language->iso_code;
		$this->module->base_link = $this->context->link->getPageLink('index', true);
		
		$link = OrangeMoneyCmrPayment::sendPaymentResquest($order, $this->module, $customer_details);

		if ($link) {
			Tools::redirectLink($link);
		} else {
			$this->module->orangeMoneyOrderConfirmation($order, $customer, Configuration::get('PS_OS_ERROR'));
		}	
	}
}
