'use strict';

function updateDeleteRange() {
    if ($('.radius-range').length > 1) {
        $('.radius-range td:last-child a').removeClass('hide');
    } else {
        $('.radius-range td:last-child a').addClass('hide');
    }
}

function onBillingChange(value) {
    if (value === 'PRICE_FREE') {
        $('ps-input-text[name=price], ps-input-text[name=base_price], ps-switch[name=round], [name^=min_billing], #radius-ranges, #radius-price-mode').addClass('hide');
        $('ps-input-text[name=min_distance], ps-input-text[name=min_duration], ps-input-text[name=max_distance], ps-input-text[name=max_duration]').removeClass('hide');
    } else if (value === 'PRICE_NATIVE') {
        $('ps-input-text[name=price], ps-input-text[name=base_price], ps-switch[name=round], [name^=min_billing], #radius-ranges, #radius-price-mode').addClass('hide');
        $('ps-input-text[name=min_distance], ps-input-text[name=min_duration], ps-input-text[name=max_distance], ps-input-text[name=max_duration]').removeClass('hide');
    } else if (value === 'PRICE_DISTANCE') {
        $('ps-input-text[name=price], ps-input-text[name=base_price], ps-input-text[name=min_distance], ps-input-text[name=max_distance], ps-switch[name=round], [name^=min_billing], #radius-price-mode').removeClass('hide');
        $('#radius-ranges, ps-input-text[name=min_billing_duration]').addClass('hide');
    } else if (value === 'PRICE_DURATION') {
        $('ps-input-text[name=price], ps-input-text[name=base_price], ps-input-text[name=min_duration], ps-input-text[name=max_duration], ps-switch[name=round], [name^=min_billing], #radius-price-mode').removeClass('hide');
        $('#radius-ranges, ps-input-text[name=min_billing_distance]').addClass('hide');
    } else {
        $('ps-input-text[name=price], ps-input-text[name=base_price], ps-input-text[name=min_distance], ps-input-text[name=min_duration], ps-input-text[name=max_distance], ps-input-text[name=max_duration], ps-switch[name=round], [name^=min_billing], #radius-price-mode').addClass('hide');
        if (value === 'PRICE_DURATION_RANGE') {
            $('#radius-ranges .form-group .input-group:not(:first-child) .input-group-addon').text('min');
        } else if (value === 'PRICE_DISTANCE_RANGE') {
            $('#radius-ranges .form-group .input-group:not(:first-child) .input-group-addon').text('km');
        }
        $('#radius-ranges').removeClass('hide');
        updateDeleteRange();
    }
}

function checkCoordinates() {
    var latitude = $('ps-input-text[name=latitude] input').val();
    var longitude = $('ps-input-text[name=longitude] input').val();
    if (latitude && longitude) {
        window.open('https://www.google.com/maps/search/?api=1&query='+latitude+','+longitude, '_blank');
    } else {
        alert(coordinates_error);
    }
}

function addRadiusRange() {
    var range = $('.radius-range').first().clone();
    range.find('input').val('');
    $('#radius-ranges table').append(range);
    updateDeleteRange();
}

function removeRadiusRange(range) {
    $(range).parents('.radius-range').remove();
    updateDeleteRange();
}

$(document).ready(function() {
    onBillingChange($('ps-select[name=billing] select').val());
});
