<script type="text/javascript">
    var coordinates_error = "{l s='Missing latitude or longitude' mod='radiusdelivery'}";
</script>

<ps-panel icon="icon-add" header="{if $carrier}{l s='Edit carrier' mod='radiusdelivery'}{else}{l s='Add carrier' mod='radiusdelivery'}{/if}">
    <form class="form-horizontal" action="{$current_url|escape:'quotes':'UTF-8'}" method="post">

        {if $carrier}
            <input type="hidden" value="{$carrier->id|intval}" name="id_carrier" />
        {else}
            <ps-input-text name="name" label="{l s='Name' mod='radiusdelivery'}" fixed-width="lg"></ps-input-text>
        {/if}

        <ps-input-text name="latitude" label="{l s='Latitude' mod='radiusdelivery'}" value="{if $rule}{$rule.latitude|floatval}{/if}" fixed-width="lg" placeholder="48.8762495" help="{l s='Latitude from where you want to calculate the distance. You can find the latitude and longitude on' mod='radiusdelivery'} <a href='https://www.latlong.net/' target='_blank'>latlong.net</a>"></ps-input-text>
        <ps-input-text name="longitude" label="{l s='Longitude' mod='radiusdelivery'}" value="{if $rule}{$rule.longitude|floatval}{/if}" fixed-width="lg" placeholder="2.343264" help="{l s='Longitude from where you want to calculate the distance. You can find the latitude and longitude on' mod='radiusdelivery'} <a href='https://www.latlong.net/' target='_blank'>latlong.net</a>"></ps-input-text>

        <ps-form-group>
            <a href="javascript:checkCoordinates();" class="btn btn-default ">
                {l s='Validate coordinates' mod='radiusdelivery'}
            </a>
	    </ps-form-group>

        <ps-panel-divider></ps-panel-divider>

        <ps-select label="{l s='Billing' mod='radiusdelivery'}" name="billing" fixed-width="xl" on-change="onBillingChange">
            <option value="PRICE_FREE" {if $rule && $rule.billing == 'PRICE_FREE'}selected{/if}>{l s='Free' mod='radiusdelivery'}</option>
            <option value="PRICE_NATIVE" {if $rule && $rule.billing == 'PRICE_NATIVE'}selected{/if}>{l s='Native (weigth/price)' mod='radiusdelivery'}</option>
            <option value="PRICE_DISTANCE" {if $rule && $rule.billing == 'PRICE_DISTANCE'}selected{/if}>{l s='Price per' mod='radiusdelivery'} km</option>
            <option value="PRICE_DURATION" {if $rule && $rule.billing == 'PRICE_DURATION'}selected{/if}>{l s='Price per minute' mod='radiusdelivery'}</option>
            <option value="PRICE_DISTANCE_RANGE" {if $rule && $rule.billing == 'PRICE_DISTANCE_RANGE'}selected{/if}>{l s='Ranges (distance)' mod='radiusdelivery'}</option>
            <option value="PRICE_DURATION_RANGE" {if $rule && $rule.billing == 'PRICE_DURATION_RANGE'}selected{/if}>{l s='Ranges (time)' mod='radiusdelivery'}</option>
        </ps-select>

        <ps-input-text name="price" label="{l s='Price' mod='radiusdelivery'}" value="{if $rule}{$rule.price|floatval}{/if}" suffix="{$currency->sign|escape:'htmlall':'UTF-8'}" fixed-width="lg" class="hide" help="{l s='Price for each minute or' mod='radiusdelivery'} km"></ps-input-text>

        <ps-input-text name="base_price" label="{l s='Base price' mod='radiusdelivery'}" value="{if $rule}{$rule.base_price|floatval}{/if}" suffix="{$currency->sign|escape:'htmlall':'UTF-8'}" fixed-width="lg" class="hide" help="{l s='Fixed price added to the variable price.' mod='radiusdelivery'} {l s='Leave to 0 to ignore.' mod='radiusdelivery'}"></ps-input-text>

        <ps-input-text name="min_billing_distance" label="{l s='Min billing distance' mod='radiusdelivery'}" value="{if $rule && isset($rule.min_billing_distance)}{$rule.min_billing_distance|floatval}{/if}" suffix="km" help="{l s='Set to 0 to ignore. Delivery will be free under this distance.' mod='radiusdelivery'}" fixed-width="lg" class="hide"></ps-input-text>

        <ps-input-text name="min_billing_duration" label="{l s='Min billing duration' mod='radiusdelivery'}" value="{if $rule && isset($rule.min_billing_duration)}{$rule.min_billing_duration|floatval}{/if}" suffix="{l s='Minutes' mod='radiusdelivery'}" help="{l s='Set to 0 to ignore. Delivery will be free under this duration.' mod='radiusdelivery'}" fixed-width="lg" class="hide"></ps-input-text>

        <ps-switch name="min_billing_deduct" label="{l s='Deduct min billing' mod='radiusdelivery'}" yes="{l s='Yes' mod='radiusdelivery'}" no="{l s='No' mod='radiusdelivery'}" active="{if $rule && isset($rule.min_billing_deduct) && $rule.min_billing_deduct}true{else}false{/if}" help="{l s='Activate this option if you want to deduct the min billing from the total.' mod='radiusdelivery'}" class="hide"></ps-switch>

        <ps-input-text name="min_distance" label="{l s='Min distance' mod='radiusdelivery'}" value="{if $rule && isset($rule.min_distance)}{$rule.min_distance|floatval}{/if}" suffix="km" help="{l s='Set to 0 to ignore.' mod='radiusdelivery'}" fixed-width="lg" class="hide"></ps-input-text>

        <ps-input-text name="max_distance" label="{l s='Max distance' mod='radiusdelivery'}" value="{if $rule}{$rule.max_distance|floatval}{/if}" suffix="km" help="{l s='Set to 0 to ignore.' mod='radiusdelivery'}" fixed-width="lg" class="hide"></ps-input-text>

        <ps-input-text name="min_duration" label="{l s='Min duration' mod='radiusdelivery'}" value="{if $rule && isset($rule.min_duration)}{$rule.min_duration|intval}{/if}" suffix="{l s='Minutes' mod='radiusdelivery'}" help="{l s='Set to 0 to ignore.' mod='radiusdelivery'}" fixed-width="lg" class="hide"></ps-input-text>

        <ps-input-text name="max_duration" label="{l s='Max duration' mod='radiusdelivery'}" value="{if $rule}{$rule.max_duration|intval}{/if}" suffix="{l s='Minutes' mod='radiusdelivery'}" help="{l s='Set to 0 to ignore.' mod='radiusdelivery'}" fixed-width="lg" class="hide"></ps-input-text>

        <ps-input-text name="min_price" label="{l s='Min order total' mod='radiusdelivery'}" value="{if $rule && isset($rule.min_price)}{$rule.min_price|floatval}{/if}" suffix="{$currency->sign|escape:'htmlall':'UTF-8'}" help="{l s='Set to 0 to ignore.' mod='radiusdelivery'}" fixed-width="lg"></ps-input-text>

        <ps-input-text name="max_price" label="{l s='Max order total' mod='radiusdelivery'}" value="{if $rule && isset($rule.max_price)}{$rule.max_price|floatval}{/if}" suffix="{$currency->sign|escape:'htmlall':'UTF-8'}" help="{l s='Set to 0 to ignore.' mod='radiusdelivery'}" fixed-width="lg"></ps-input-text>

        <ps-input-text name="min_weight" label="{l s='Min order weight' mod='radiusdelivery'}" value="{if $rule && isset($rule.min_weight)}{$rule.min_weight|floatval}{/if}" suffix="{$units.weigth|escape:'htmlall':'UTF-8'}" help="{l s='Set to 0 to ignore.' mod='radiusdelivery'}" fixed-width="lg"></ps-input-text>

        <ps-input-text name="max_weight" label="{l s='Max order weight' mod='radiusdelivery'}" value="{if $carrier}{$carrier->max_weight|floatval}{/if}" suffix="{$units.weigth|escape:'htmlall':'UTF-8'}" help="{l s='Set to 0 to ignore.' mod='radiusdelivery'}" fixed-width="lg"></ps-input-text>

        <ps-select label="{l s='Price mode' mod='radiusdelivery'}" id="radius-price-mode" name="price_mode" fixed-width="xl" help="{l s='Normal: 20.34' mod='radiusdelivery'}<br />{l s='Rounded: 20.00' mod='radiusdelivery'}<br />{l s='Psychological: 19.99' mod='radiusdelivery'}">
            <option value="PRICE_MODE_NORMAL" {if $rule && $rule.price_mode == 'PRICE_MODE_NORMAL'}selected{/if}>
                {l s='Normal' mod='radiusdelivery'}
            </option>
            <option value="PRICE_MODE_ROUNDED" {if $rule && $rule.price_mode == 'PRICE_MODE_ROUNDED'}selected{/if}>
                {l s='Rounded' mod='radiusdelivery'}
            </option>
            <option value="PRICE_MODE_PSYCHOLOGICAL" {if $rule && $rule.price_mode == 'PRICE_MODE_PSYCHOLOGICAL'}selected{/if}>
                {l s='Psychological' mod='radiusdelivery'}
            </option>
        </ps-select>

        <ps-form-group label="{l s='Ranges' mod='radiusdelivery'}" id="radius-ranges">
            <table class="table">
                <tbody>
                    {if !$rule || empty($rule.ranges)}
                        {include file='./range.tpl' price=0 range_min=0 range_max=0}
                    {else}
                        {foreach from=$rule.ranges item=range}
                            {include file='./range.tpl' price=$range.price range_min=$range.min range_max=$range.max}
                        {/foreach}
                    {/if}
                </tbody>
            </table>
            <a href="javascript:addRadiusRange();" class="btn btn-default ">
                <i class="icon-plus-sign"></i> {l s='Add range' mod='radiusdelivery'}
            </a>
        </ps-form-group>

        <ps-panel-footer>
            <ps-panel-footer-submit title="{l s='Save' mod='radiusdelivery' mod='radiusdelivery'}" icon="process-icon-save" direction="right" name="submitCarrier"></ps-panel-footer-submit>
        </ps-panel-footer>

    </form>
</ps-panel>
