<?php
/**
* 2007-2015 PrestaShop
*
* NOTICE OF LICENSE
*
* This source file is subject to the Academic Free License (AFL 3.0)
* that is bundled with this package in the file LICENSE.txt.
* It is also available through the world-wide-web at this URL:
* http://opensource.org/licenses/afl-3.0.php
* If you did not receive a copy of the license and are unable to
* obtain it through the world-wide-web, please send an email
* to license@prestashop.com so we can send you a copy immediately.
*
* DISCLAIMER
*
* Do not edit or add to this file if you wish to upgrade PrestaShop to newer
* versions in the future. If you wish to customize PrestaShop for your
* needs please refer to http://www.prestashop.com for more information.
*
*  @author    PrestaShop SA <contact@prestashop.com>
*  @copyright 2007-2015 PrestaShop SA
*  @license   http://opensource.org/licenses/afl-3.0.php  Academic Free License (AFL 3.0)
*  International Registered Trademark & Property of PrestaShop SA
*/
class Form
{
    protected $table = 'quot_form';

    private $id_form;
    private $id_lang;
    private $form_name;
    private $active;
    private $id_shop;
    private $id_shop_group;

    public function __construct($id_form = null, $id_lang = null, $form_name = null, $active = null, $id_shop = null, $id_shop_group = null)
    {
        $this->id_form 			= pSQL($id_form);
        $this->id_lang 			= pSQL($id_lang);
        $this->form_name 		= pSQL($form_name);
        $this->active 			= pSQL($active);
        $this->id_shop 			= pSQL($id_shop);
        $this->id_shop_group 	= pSQL($id_shop_group);

        if(is_null($this->active))
            $this->active = 0;
        if(is_null($this->id_shop))
            $this->id_shop = $this->context->shop->id;
        if(is_null($this->id_shop_group))
            $this->id_shop_group = $this->context->shop->id_group;
    }

    public function save()
    {
        if(is_null($this->id_form))
            $id_form = 'NULL';
        else
            $id_form = $this->id_form;

        $sql = 'REPLACE INTO `'._DB_PREFIX_.bqSQL($this->table).'` VALUES ("'.$id_form.'", "'.$this->id_lang.'", "'.$this->form_name.'", "'.$this->active.'", "'.$this->id_shop.'", "'.$this->id_shop_group.'")';

        if(Db::getInstance()->execute($sql))
        {
            $this->id_form = Db::getInstance()->Insert_ID();
            return true;
        }
        else
            return false;
    }

    // Setters
    public function setIdForm($val)
    {
        $this->id_form = pSQL($val);
    }

    public function setIdLang($val)
    {
        $this->id_lang = pSQL($val);
    }

    public function setFormName($val)
    {
        $this->form_name = pSQL($val);
    }

    public function setActive($val)
    {
        $this->active = pSQL($val);
    }

    public function setIdShop($val)
    {
        $this->id_shop = pSQL($val);
    }

    public function setIdShopGroup($val)
    {
        $this->id_shop_group = pSQL($val);
    }

    // Getters
    public function getIdForm()
    {
        return $this->id_form;
    }

    public function getIdLang()
    {
        return $this->id_lang;
    }

    public function getFormName()
    {
        return $this->form_name;
    }

    public function getActive()
    {
        return $this->active;
    }

    public function getIdShop()
    {
        return $this->id_shop;
    }

    public function getIdShopGroup()
    {
        return $this->id_shop_group;
    }

    public function getListForm()
    {

    }
    
}
