<?php
/**
* 2007-2015 PrestaShop
*
* NOTICE OF LICENSE
*
* This source file is subject to the Academic Free License (AFL 3.0)
* that is bundled with this package in the file LICENSE.txt.
* It is also available through the world-wide-web at this URL:
* http://opensource.org/licenses/afl-3.0.php
* If you did not receive a copy of the license and are unable to
* obtain it through the world-wide-web, please send an email
* to license@prestashop.com so we can send you a copy immediately.
*
* DISCLAIMER
*
* Do not edit or add to this file if you wish to upgrade PrestaShop to newer
* versions in the future. If you wish to customize PrestaShop for your
* needs please refer to http://www.prestashop.com for more information.
*
*  @author    PrestaShop SA <contact@prestashop.com>
*  @copyright 2007-2015 PrestaShop SA
*  @license   http://opensource.org/licenses/afl-3.0.php  Academic Free License (AFL 3.0)
*  International Registered Trademark & Property of PrestaShop SA
*/
class FormField
{
	protected $table = 'quot_form_field';

	private $id_field;
	private $id_form;
	private $label;
	private $field_name;
	private $type_field;
	private $value;
	private $id_parent;
	private $pos;
	private $id_lang;

	public function __construct($id_field = 'NULL', $id_form = null, $label = null, $field_name = null, $type_field = null, $value = null, $id_parent = null, $pos = null, $id_lang = null)
	{
		$this->id_field 	= pSQL($id_field);
		$this->id_form 		= pSQL($id_form);
		$this->label 		= pSQL($label);
		$this->field_name 	= pSQL($field_name);
		$this->type_field 	= pSQL($type_field);
		$this->value 		= pSQL($value);
		$this->id_parent 	= pSQL($id_parent);
		$this->pos 			= pSQL($pos);
		$this->id_lang 		= pSQL($id_lang);
	}

	public function save()
	{
		if(is_null($this->id_field))
			$id_field = 'NULL';
		else
			$id_field = $this->id_field;

		$sql = 'INSERT INTO `'._DB_PREFIX_.bqSQL($this->table).'` VALUES ("'.$id_field.'", "'.$this->id_form.'", "'.$this->label.'", "'.$this->field_name.'", "'.$this->type_field.'", "'.$this->value.'", '.$this->id_parent.', '.$this->pos.', '.$this->id_lang.')';

		if(Db::getInstance()->execute($sql))
			return Db::getInstance()->Insert_ID();
	}
	
	static public function edit($id_field, $id_lang, $val)
	{
		$sql = 'UPDATE `'._DB_PREFIX_.'quot_form_field` SET value = "'.pSQL($val).'", label = "'.pSQL($val).'", name = "'.pSQL($val).'" WHERE id = '.(int)$id_field.' AND id_lang = '.(int)$id_lang; 
		Db::getInstance()->execute($sql);
	}

	// Setters
	public function setIdField($val)
	{
		$this->id_field = pSQL($val);
	}

	public function setIdForm($val)
	{
		$this->id_form = pSQL($val);
	}

	public function setLabel($val)
	{
		$this->label = pSQL($val);
	}

	public function setName($val)
	{
		$this->field_name = pSQL($val);
	}
	
	public function setTypeField($val)
	{
		$this->type_field = pSQL($val);
	}
	
	public function setValue($val)
	{
		$this->value = pSQL($val);
	}
	
	public function setIdParent($val)
	{
		$this->id_parent = pSQL($val);
	}
	
	public function setPos($val)
	{
		$this->pos = pSQL($val);
	}
	public function setIdLang($val)
	{
		$this->id_lang = pSQL($val);
	}
	
	// Getters
	public function getIdField()
	{
		return $this->id_field;
	}
	
	public function getIdForm()
	{
		return $this->id_form;
	}
	
	public function getLabel()
	{
		return $this->label;
	}
	
	public function getName()
	{
		return $this->field_name;
	}
	
	public function getTypeField()
	{
		return $this->type_field;
	}
	
	public function getValue()
	{
		return $this->value;
	}
	
	public function getIdParent()
	{
		return $this->id_parent;
	}
	
	public function getPos()
	{
		return $this->pos;
	}
	public function getIdLang()
	{
		return $this->id_lang;
	}
}