<?php
/**
* 2007-2015 PrestaShop
*
* NOTICE OF LICENSE
*
* This source file is subject to the Academic Free License (AFL 3.0)
* that is bundled with this package in the file LICENSE.txt.
* It is also available through the world-wide-web at this URL:
* http://opensource.org/licenses/afl-3.0.php
* If you did not receive a copy of the license and are unable to
* obtain it through the world-wide-web, please send an email
* to license@prestashop.com so we can send you a copy immediately.
*
* DISCLAIMER
*
* Do not edit or add to this file if you wish to upgrade PrestaShop to newer
* versions in the future. If you wish to customize PrestaShop for your
* needs please refer to http://www.prestashop.com for more information.
*
*  @author    PrestaShop SA <contact@prestashop.com>
*  @copyright 2007-2015 PrestaShop SA
*  @license   http://opensource.org/licenses/afl-3.0.php  Academic Free License (AFL 3.0)
*  International Registered Trademark & Property of PrestaShop SA
*/
class QuotationObj {

    protected $table = 'quot';
    private $id_quot;
    private $id_customer;
    private $id_guest;
    private $id_shop;
    private $products;
    private $id_statut;
    private $id_form;
    private $id_cart = 0;
    private $id_cart_rule = 0;
    private $id_currency = null;

    public function __construct($id_quot = null, $id_customer = null, $id_guest = null, $id_shop = null, $id_form = null, $id_statut = 0, $id_currency = null)
    {
        if(is_null($id_quot))
            $id_quot = 'NULL';
        if(is_null($id_customer))
            $id_customer = 'NULL';
        if(is_null($id_guest))
            $id_guest = 'NULL';
        if(is_null($id_form))
            $id_form = 'NULL';

        $this->id_quot 		= $id_quot;
        $this->id_customer 	= $id_customer;
        $this->id_guest 	= $id_guest;
        $this->id_shop 		= $id_shop;
        $this->id_statut	= $id_statut;
        $this->id_form 		= $id_form;
        $this->id_currency	= $id_currency;
    }

    public function save()
    {
        $context = Context::getContext();
        $id_currency = $context->cookie->__get('id_currency');
        $query = 'REPLACE INTO '._DB_PREFIX_.$this->table.' VALUES ('.(int)$this->id_quot.', '.(int)$this->id_customer.', '.(int)$this->id_guest.', '.(int)$this->id_shop.', NULL, NOW(), '.(int)$this->id_statut.', '.(int)$this->id_form.', 0, 0, '.(int)$id_currency.');';

        if(Db::getInstance()->execute($query))
        {
            $this->id_quot = (int)Db::getInstance()->Insert_ID();
            return $this->id_quot;
        }
        else
            return false;

    }
    public function getProducts($id_statut = null, $filter_customer = false, $filter_guest = false)
    {
        if(is_null($this->id_quot) || $this->id_quot == 'NULL')
            return array();
        $query = 'SELECT *
            FROM '._DB_PREFIX_.$this->table.' q
            INNER JOIN '._DB_PREFIX_.'quot_product qp ON q.id_quot = qp.id_quot
            WHERE q.id_quot = '.(int)$this->id_quot;

        if($filter_customer)
            $query .= ' AND (id_customer = '.(int)$this->id_customer;

        if($filter_guest)
        {
            if($filter_customer)
                $query .= ' OR ';
            else
                $query .= ' (AND ';
            $query .= ' id_guest = '.(int)$this->id_guest.')';
        }
        elseif($filter_customer)
            $query .= ')';

        // if(!is_null($id_statut))
            // $query .= ' AND id_statut < 1';

        return Db::getInstance()->executeS($query);
    }

    private function getAttributes($id_combination)
    {
        if(isset(Context::getContext()->cart->id_lang))
            $id_lang = Context::getContext()->cart->id_lang;
        else
            $id_lang = Context::getContext()->employee->id_lang;

        $query = 'SELECT al.name, agl.public_name
                FROM '._DB_PREFIX_.'product_attribute_combination pac
                JOIN '._DB_PREFIX_.'attribute_lang al ON (pac.id_attribute = al.id_attribute AND al.id_lang='.$id_lang.')
                JOIN '._DB_PREFIX_.'attribute a ON (a.id_attribute = pac.id_attribute)
                JOIN '._DB_PREFIX_.'attribute_group_lang agl ON (agl.id_attribute_group = a.id_attribute_group AND agl.id_lang='.$id_lang.')
                WHERE pac.id_product_attribute='.(int)$id_combination.'
                GROUP BY al.id_attribute DESC';
        return Db::getInstance()->executeS($query);
    }

    private function getQuotationByStatut($id_statut)
    {
        $query = 'SELECT *
            FROM '._DB_PREFIX_.$this->table.' q
            WHERE q.id_customer = '.(int)$this->id_customer.'
            AND id_statut = '.(int)$id_statut;
        return Db::getInstance()->executeS($query);
    }

    public function init($getResult = false, $id_statut = 1, $filter_customer = true, $filter_guest = true)
    {
        // if($quot_temp = $this->getQuotationByStatut(0))
            // $this->id_quot = $quot_temp[0]['id_quot'];
        $result = $this->getProducts($id_statut, $filter_customer, $filter_guest);

        if(!isset($result[0]))
        {
            if($getResult)
                return true;

            $context = Context::getContext();
            $context->cookie->__set('id_quotation' , $this->id_quot);
            $context->cookie->__set('products' , Tools::jsonEncode(array()));
            $context->cookie->__set('total_cart' , 0);
            $context->cookie->__set('total_product' , 0);

            return true;
        }

        $products = array();
        $total_cart = 0;
        $total_product = 0;

        if(isset(Context::getContext()->cart->id_lang))
            $id_lang = Context::getContext()->cart->id_lang;
        else
            $id_lang = Context::getContext()->employee->id_lang;

        $context = Context::getContext();

        $id_currency = $this->getIdCurrency();
        if(!isset($id_currency))
            $id_currency = Currency::getDefaultCurrency()->id;

        $context->currency = new Currency($id_currency);

        if($this->getIdCustomer() > 0)
            $id_group = Customer::getDefaultGroupId($this->getIdCustomer());
        else
            $id_group = 1;

        $tax = !Group::getPriceDisplayMethod($id_group);

        foreach($result as $r)
        {
            // TODO ID SHOP
            $product = new Product((int)$r['id_product'], false, $id_lang, Shop::getContextShopID());
            $link = $product->getLink();
            $ref = null;

            $price = round(Product::getPriceStatic($r['id_product'], (bool)$tax, $r['id_combination'], 6, null, false, true, $r['quantity'], false, null, null, null, $ref, null, true, $context), 2);

            $products[$r['id_product'].'_'.$r['id_combination']]['id_product'] = $r['id_product'];
            $products[$r['id_product'].'_'.$r['id_combination']]['id_combination'] = $r['id_combination'];
            $products[$r['id_product'].'_'.$r['id_combination']]['quantity'] = $r['quantity'];
            $products[$r['id_product'].'_'.$r['id_combination']]['date_add'] = $r['date_add'];
            $products[$r['id_product'].'_'.$r['id_combination']]['date_add'] = $r['date_add'];
            $products[$r['id_product'].'_'.$r['id_combination']]['price'] = $price*$r['quantity'];
            $products[$r['id_product'].'_'.$r['id_combination']]['img'] = self::getImagePath($id_lang, $r['id_product'], $r['id_combination']);

            $products[$r['id_product'].'_'.$r['id_combination']]['link'] = $link;

            $name = $product->name;

            foreach($this->getAttributes($r['id_combination']) as $attribute)
            {
                $name .= ' ,'.$attribute['public_name'].' - '.$attribute['name'];
            }
            $products[$r['id_product'].'_'.$r['id_combination']]['name'] = $name;
            $total_cart += $price*$r['quantity'];
            $total_product += $r['quantity'];
        }

        if(!$getResult)
        {
            $context = Context::getContext();

            $context->cookie->__set('id_quotation' , $result[0]['id_quot']);
            $context->cookie->__set('products' , Tools::jsonEncode($products));
            $context->cookie->__set('total_cart' , $total_cart);
            $context->cookie->__set('total_product' , $total_product);
            return true;
        }
        else
        {
            return array('products' => $products, 'total_cart' => $total_cart, 'total_product' => $total_product);
        }
    }

    public function addProduct($id_product, $id_combination, $quantity)
    {
        $query = 'SELECT quantity FROM '._DB_PREFIX_.'quot_product WHERE id_quot = '.(int)$this->id_quot.' AND id_product = '.(int)$id_product.' AND id_combination = '.(int)$id_combination;
        $product = Db::getInstance()->executeS($query);

        if(is_array($product) && isset($product[0]))
            $quantity += $product[0]['quantity'];

        $query = 'REPLACE INTO '._DB_PREFIX_.'quot_product VALUES ('.$this->id_quot.', '.(int)$id_product.', '.(int)$id_combination.', '.(int)$quantity.', NOW());';

        $this->init();
        return Db::getInstance()->execute($query);
    }

    public function getIdQuot()
    {
        return $this->id_quot;
    }
    public function getIdCustomer()
    {
        if(!isset($this->id_customer) || $this->id_customer = 'NULL')
        {
            $query = 'SELECT id_customer FROM '._DB_PREFIX_.$this->table.' WHERE id_quot = '.(int)$this->id_quot;
            $id_customer = Db::getInstance()->getValue($query);
            $this->id_customer = $id_customer;
        }
        return $this->id_customer;
    }
    public static function getIdCustomerStatic($id_quot)
    {
        $query = 'SELECT id_customer FROM '._DB_PREFIX_.'quot WHERE id_quot = '.(int)$id_quot;
        $id_customer = Db::getInstance()->getValue($query);
        return $id_customer;
    }
    public function getIdShop()
    {
        return $this->id_shop;
    }
    public function getIdCurrency()
    {
        if($this->id_currency > 0)
            return $this->id_currency;
        $query = 'SELECT id_currency FROM '._DB_PREFIX_.$this->table.' WHERE id_quot = '.(int)$this->id_quot;
        $this->id_currency = Db::getInstance()->getValue($query);
        return $this->id_currency;
    }
    public function getIdCart()
    {
        if($this->id_cart > 0)
            return $this->id_cart;
        $query = 'SELECT id_cart FROM '._DB_PREFIX_.$this->table.' WHERE id_quot = '.(int)$this->id_quot;
        $this->id_cart = Db::getInstance()->getValue($query);
        return $this->id_cart;
    }
    public function getIdCartRule()
    {
        if($this->id_cart_rule > 0)
            return $this->id_cart_rule;
        $query = 'SELECT id_cart_rule FROM '._DB_PREFIX_.$this->table.' WHERE id_quot = '.(int)$this->id_quot;
        $this->id_cart_rule = Db::getInstance()->getValue($query);
        return $this->id_cart_rule;
    }

    public function getCartRuleValue()
    {
        $query = 'SELECT reduction_amount FROM '._DB_PREFIX_.$this->table.' q JOIN '._DB_PREFIX_.'cart_rule cr ON cr.id_cart_rule = q.id_cart_rule WHERE q.id_quot = '.(int)$this->id_quot;
        return Db::getInstance()->getValue($query);
    }

    public static function getCustomerDetails($id_customer)
    {
        $query = 'SELECT lastname, firstname FROM '._DB_PREFIX_.'customer WHERE id_customer = '.(int)$id_customer;
        $customer = Db::getInstance()->getRow($query);
        return $customer;
    }
    public static function updateStatut($id_quot, $statut, $sendMail = false)
    {
        $query = 'UPDATE '._DB_PREFIX_.'quot SET id_statut = '.(int)$statut.' WHERE id_quot = '.(int)$id_quot;
        if(!Db::getInstance()->Execute($query))
            return false;
        if(!$sendMail)
            return true;

        $id_customer = (int)self::getIdCustomerStatic($id_quot);
        $query = 'SELECT email, id_lang FROM '._DB_PREFIX_.'customer WHERE id_customer = '.$id_customer;
        $to = Db::getInstance()->ExecuteS($query);

        $args = array();
        $args['{id_quot}'] = Configuration::get('QUOTATION_PREFIX').''.$id_quot;
        $args['{logo}'] =  _PS_BASE_URL_.__PS_BASE_URI__.'/img/'.Configuration::get('PS_LOGO', null, Context::getContext()->shop->id_shop_group, Context::getContext()->shop->id);

        if(Tools::strlen(Context::getContext()->cookie->customer_firstname) > 0)
            $args['{customer_details}'] = Context::getContext()->cookie->customer_firstname.' '.Context::getContext()->cookie->customer_lastname.' (ID '.Context::getContext()->cookie->id_customer.')';
        else
        {
            $customer = self::getCustomerDetails($id_customer);
            $args['{customer_details}'] = $customer['firstname'].' '.$customer['lastname'].' (ID '.$id_customer.')';
            $args['{customer_details_client}'] = $customer['firstname'].' '.$customer['lastname'];
        }

        $args['{shop_name}'] = Configuration::get('PS_SHOP_NAME', null, Shop::getContextShopGroupID(), Shop::getContextShopID());
        $args['{customerquotations_URL}'] =  _PS_BASE_URL_.__PS_BASE_URI__.'?fc=module&module=quotation&controller=customerquotations&id_quotation='.Context::getContext()->cookie->id_quotation;

        $iso_lang = Language::getIsoById($to[0]['id_lang']);
        $stautut_value = Db::getInstance()->getValue('SELECT value FROM '._DB_PREFIX_.'quot_statut WHERE id_statut = '.(int)$statut.' AND id_lang = "'.$iso_lang.'"');

        $args['{quote_statement}'] = $stautut_value;

        $quotation = Module::getInstanceByName('quotation');

        $quotation->sendMail('status_change', Configuration::get('PS_SHOP_EMAIL'), Configuration::get('PS_LANG_DEFAULT', null, Shop::getContextShopGroupID(), Shop::getContextShopID()), $args);

        $quotation->sendMail('status_change_client', $to[0]['email'], $to[0]['id_lang'], $args);
        return true;
    }

    public static function getIdQuotByIdCart($id_cart) {
        $query = 'SELECT id_quot FROM '._DB_PREFIX_.'quot WHERE id_cart = '.(int)$id_cart;
        return Db::getInstance()->getValue($query);
    }

    public static function getCustomerInfosByIdQuot($id_quot) {
        $query = 'SELECT c.email, c.id_customer FROM '._DB_PREFIX_.'customer c JOIN '._DB_PREFIX_.'quot q ON (q.id_customer = c.id_customer) WHERE id_quot = '.(int)$id_quot;
        return Db::getInstance()->getRow($query);
    }

    private static function getImagePath($id_lang, $id_product, $id_combination)
    {
        $cover_dir = Image::getImages($id_lang, $id_product, $id_combination);

        if(!isset($cover_dir[0]['id_image']))
            $cover_dir = Image::getImages($id_lang, $id_product);

        if(!isset($cover_dir[0]['id_image']))
            return false;

        $img_dir = implode('/', str_split($cover_dir[0]['id_image']));
        return _PS_BASE_URL_._PS_IMG_.'p/'.$img_dir.'/'.$cover_dir[0]['id_image'].'-'.ImageType::getFormatedName('small').'.jpg';
    }
}
