<?php
/**
* 2007-2015 PrestaShop
*
* NOTICE OF LICENSE
*
* This source file is subject to the Academic Free License (AFL 3.0)
* that is bundled with this package in the file LICENSE.txt.
* It is also available through the world-wide-web at this URL:
* http://opensource.org/licenses/afl-3.0.php
* If you did not receive a copy of the license and are unable to
* obtain it through the world-wide-web, please send an email
* to license@prestashop.com so we can send you a copy immediately.
*
* DISCLAIMER
*
* Do not edit or add to this file if you wish to upgrade PrestaShop to newer
* versions in the future. If you wish to customize PrestaShop for your
* needs please refer to http://www.prestashop.com for more information.
*
*  @author    PrestaShop SA <contact@prestashop.com>
*  @copyright 2007-2015 PrestaShop SA
*  @license   http://opensource.org/licenses/afl-3.0.php  Academic Free License (AFL 3.0)
*  International Registered Trademark & Property of PrestaShop SA
*/
class DiscountController{

	public function __construct (){

	}

	public static function createDiscount($id_cart, $value, $id_cart_rule = null, $name = null, $tax = 1, $id_currency = 1)
	{
		$to = Db::getInstance()->ExecuteS('
				SELECT c.id_customer, c.id_lang, cc.email FROM `'._DB_PREFIX_.'cart` c
				JOIN '._DB_PREFIX_.'customer cc ON c.id_customer = cc.id_customer
				WHERE id_cart = '.(int)$id_cart);
		$code = 'Q'.Tools::substr(sha1(microtime()), 6, 5);

		$cart = new Cart($id_cart);
		$total_cart = $cart->getordertotal(false);

		$now = time();
		$date_from = date('Y-m-d H:i:s', $now);
		$date_to = '2031-01-17 23:59:59';
		$description = 'Quotation '.$code;

		Db::getInstance()->execute('
				REPLACE INTO `'._DB_PREFIX_.'cart_rule`
				VALUES ('.(int)$id_cart_rule.', '.(int)$to[0]['id_customer'].', "'.$date_from.'", "'.$date_to.'", "'.$description.'", 1, 1, 1, 0, "'.$code.'", '.$total_cart.', 0, '.(int)$cart->id_currency.', 0, 0, 0, 0, 0, 0,'.(int)Shop::getContextShopId().', 0, 0, '.(float)$value.', '.(int)$tax.', '.(int)$id_currency.', 0, 0, 0, 0, 1, NOW(), NOW())');

		$id_cart_rule = Db::getInstance()->Insert_ID();
		$langs = Language::getLanguages(true, Shop::getContextShopId());
		foreach($langs as $lang)
		{
			Db::getInstance()->execute('
				REPLACE INTO `'._DB_PREFIX_.'cart_rule_lang`
				VALUES ('.(int)$id_cart_rule.', '.(int)$lang['id_lang'].', "'.pSQL('Quotation '.$name).'")');
		}
		Db::getInstance()->execute('
				REPLACE INTO `'._DB_PREFIX_.'cart_cart_rule` (`id_cart`, `id_cart_rule`)
				VALUES ('.(int)$id_cart.', '.(int)$id_cart_rule.')');
		Db::getInstance()->execute('
				REPLACE INTO `'._DB_PREFIX_.'cart_rule_shop` (`id_cart_rule`, `id_shop`)
				VALUES ('.(int)$id_cart_rule.', '.(int)Shop::getContextShopId().')');
		$cart->addCartRule($id_cart_rule);

		self::sendMail($to[0]['email'], $to[0]['id_lang'], (int)$to[0]['id_customer'], (int)$id_cart);

		return $id_cart_rule;
	}

	public static function sendMail($email, $id_lang, $id_customer, $id_cart)
	{
		require_once dirname(__FILE__).'/../classes/QuotationObj.class.php';
		$args = array();
		$args['{cart_rule_value}'] = Tools::getValue('cart_rule_value').' '.Configuration::get('PS_CURRENCY_DEFAULT');
		$args['{id_quot}'] = Configuration::get('QUOTATION_PREFIX').''.QuotationObj::getIdQuotByIdCart($id_cart);
		$args['{logo}'] =  _PS_BASE_URL_.__PS_BASE_URI__.'/img/'.Configuration::get('PS_LOGO', null, Context::getContext()->shop->id_shop_group, Context::getContext()->shop->id);

		$customer = QuotationObj::getCustomerDetails($id_customer);
		$args['{customer_details_client}'] = $customer['firstname'].' '.$customer['lastname'];

		$args['{shop_name}'] = Configuration::get('PS_SHOP_NAME', null, Shop::getContextShopGroupID(), Shop::getContextShopID());
		$args['{customerquotations_URL}'] =  _PS_BASE_URL_.__PS_BASE_URI__.'?fc=module&module=quotation&controller=customerquotations&id_quotation='.Context::getContext()->cookie->id_quotation;

		$quotation = Module::getInstanceByName('quotation');
		$quotation->sendMail('quotation_validated', $email, $id_lang, $args);
	}
}