<?php
/**
* 2007-2015 PrestaShop
*
* NOTICE OF LICENSE
*
* This source file is subject to the Academic Free License (AFL 3.0)
* that is bundled with this package in the file LICENSE.txt.
* It is also available through the world-wide-web at this URL:
* http://opensource.org/licenses/afl-3.0.php
* If you did not receive a copy of the license and are unable to
* obtain it through the world-wide-web, please send an email
* to license@prestashop.com so we can send you a copy immediately.
*
* DISCLAIMER
*
* Do not edit or add to this file if you wish to upgrade PrestaShop to newer
* versions in the future. If you wish to customize PrestaShop for your
* needs please refer to http://www.prestashop.com for more information.
*
*  @author    PrestaShop SA <contact@prestashop.com>
*  @copyright 2007-2015 PrestaShop SA
*  @license   http://opensource.org/licenses/afl-3.0.php  Academic Free License (AFL 3.0)
*  International Registered Trademark & Property of PrestaShop SA
*/
class MessageController
{
	public function __construct()
	{
	}

	public static function sendMessage($id_quotation, $message, $id_employee = null)
	{

		if(is_null($id_employee))
			$id_employee = 'NULL';
		else
			$id_employee = (int)$id_employee;

		if(is_null($id_employee) || $id_employee == 0)
			$to = 'employee';
		else
			$to = 'customer';

		$query = 'INSERT INTO '._DB_PREFIX_.'quot_messages VALUES (NULL, '.(int)$id_quotation.', '.$id_employee.', NOW(), "'.pSQL($message).'", 0)';

		self::sendNotification($to, $id_quotation, $message);
		return Db::getInstance()->Execute($query);
	}

	public static function getMessages($id_quotation)
	{
		$query = 'SELECT * FROM '._DB_PREFIX_.'quot_messages WHERE id_quot = '.(int)$id_quotation;

		return Db::getInstance()->ExecuteS($query);
	}

	/*
	*	$to can be employee or customer
	*/
	private static function sendNotification($to, $id_quotation, $message)
	{
		$args = array();
		$args['{quotation_ID}'] 	= Configuration::get('QUOTATION_PREFIX').''.$id_quotation;
		$args['{logo}'] =  _PS_BASE_URL_.__PS_BASE_URI__.'/img/'.Configuration::get('PS_LOGO', null, Context::getContext()->shop->id_shop_group, Context::getContext()->shop->id);
		$args['{shop_name}'] 		= Configuration::get('PS_SHOP_NAME', null, Shop::getContextShopGroupID(), Shop::getContextShopID());
		$args['{content_message}']  = $message;
		
		if($to == 'employee')
		{
			$mail = Configuration::get('PS_SHOP_EMAIL');
			$args['{customer_name}'] = Context::getContext()->cookie->customer_firstname.' '.Context::getContext()->cookie->customer_lastname.' (ID '.Context::getContext()->cookie->id_customer.')';
			$tpl = 'new_message';
		}
		elseif($to == 'customer')
		{
			require_once dirname(__FILE__).'/../classes/QuotationObj.class.php';
			$mail = QuotationObj::getCustomerInfosByIdQuot($id_quotation);

			$id_customer = $mail['id_customer'];
			$mail = $mail['email'];
			$customer_details = QuotationObj::getCustomerDetails($id_customer);
			$args['{customer_name}'] = $customer_details['firstname'].' '.$customer_details['lastname'];
			$args['{name}'] = Context::getContext()->cookie->customer_firstname.' '.Context::getContext()->cookie->customer_lastname.' (ID '.Context::getContext()->cookie->id_customer.')';
			$args['{customerquotations_URL}'] =  _PS_BASE_URL_.__PS_BASE_URI__.'?fc=module&module=quotation&controller=customerquotations&id_quotation='.Context::getContext()->cookie->id_quotation;
			$tpl = 'new_message_client';
		}
		$quotation = Module::getInstanceByName('quotation');
		$quotation->sendMail($tpl, $mail, Configuration::get('PS_LANG_DEFAULT', null, Shop::getContextShopGroupID(), Shop::getContextShopID()), $args);
	}
}