<?php
/**
* 2007-2015 PrestaShop
*
* NOTICE OF LICENSE
*
* This source file is subject to the Academic Free License (AFL 3.0)
* that is bundled with this package in the file LICENSE.txt.
* It is also available through the world-wide-web at this URL:
* http://opensource.org/licenses/afl-3.0.php
* If you did not receive a copy of the license and are unable to
* obtain it through the world-wide-web, please send an email
* to license@prestashop.com so we can send you a copy immediately.
*
* DISCLAIMER
*
* Do not edit or add to this file if you wish to upgrade PrestaShop to newer
* versions in the future. If you wish to customize PrestaShop for your
* needs please refer to http://www.prestashop.com for more information.
*
*  @author    PrestaShop SA <contact@prestashop.com>
*  @copyright 2007-2015 PrestaShop SA
*  @license   http://opensource.org/licenses/afl-3.0.php  Academic Free License (AFL 3.0)
*  International Registered Trademark & Property of PrestaShop SA
*/

header('Expires: Mon, 26 Jul 1997 05:00:00 GMT');
header('Last-Modified: '.gmdate('D, d M Y H:i:s').' GMT');
if (!defined('_PS_VERSION_'))
    exit;

header('Cache-Control: no-store, no-cache, must-revalidate');
header('Cache-Control: post-check=0, pre-check=0', false);
header('Pragma: no-cache');
/**
 * Function used to update your module from previous versions to the version 1.0.5,
 * Don't forget to create one file per version.
 */
function upgrade_module_1_0_27($module)
{
    /**
    * Do everything you want right there,
    * You could add a column in one of your module's tables
    */
    $sql[] = "ALTER TABLE `"._DB_PREFIX_."quot_statut` ADD color varchar(100) NOT NULL";

    $sql[] = "REPLACE INTO `"._DB_PREFIX_."quot_statut` (`id_statut`, `value`, `color`, `id_lang`) VALUES
    (1, 'Validated by the client', '#FF8C00', 'en'),
    (1, 'Validé par le client', '#FF8C00', 'fr'),
    (2, 'En étude', '#4169E1', 'fr'),
    (2, 'In study', '#4169E1', 'en'),
    (3, 'Validated by the merchant', '#32CD32', 'en'),
    (3, 'Validé par le marchand', '#32CD32', 'fr'),
    (4, 'Rejected', '#DC143C', 'en'),
    (4, 'Rejeté', '#DC143C', 'fr'),
    (5, 'Cancelled', '#DC143C', 'en'),
    (5, 'Annulé', '#DC143C', 'fr'),
    (6, 'Ordered', '#FF69B4', 'en'),
    (6, 'Commandé', '#FF69B4', 'fr')";

    $sql[] = "REPLACE INTO `"._DB_PREFIX_."quot_statut` (`id_statut`, `value`, `color`, `id_lang`) VALUES ('7', 'En cours de modification', '#4169E1', 'fr'), ('7', 'Being modified', '#4169E1', 'en');";

    $return = true;
    foreach ($sql as $query) {
        if (Db::getInstance()->execute($query) == false)
            $return = false;
    }

    return $module;
}
