{*
* 2007-2015 PrestaShop
*
* NOTICE OF LICENSE
*
* This source file is subject to the Academic Free License (AFL 3.0)
* that is bundled with this package in the file LICENSE.txt.
* It is also available through the world-wide-web at this URL:
* http://opensource.org/licenses/afl-3.0.php
* If you did not receive a copy of the license and are unable to
* obtain it through the world-wide-web, please send an email
* to license@prestashop.com so we can send you a copy immediately.
*
* DISCLAIMER
*
* Do not edit or add to this file if you wish to upgrade PrestaShop to newer
* versions in the future. If you wish to customize PrestaShop for your
* needs please refer to http://www.prestashop.com for more information.
*
*  @author    PrestaShop SA <contact@prestashop.com>
*  @copyright 2007-2015 PrestaShop SA
*  @license   http://opensource.org/licenses/afl-3.0.php  Academic Free License (AFL 3.0)
*  International Registered Trademark & Property of PrestaShop SA
*
* Don't forget to prefix your containers with your own identifier
* to avoid any conflicts with others containers.
*}
<div id="quotation_detail_header">
    <h2>{l s='Quotation details' mod='quotation'}</h2>
    <br><br>
    <table class="display table">
        <tr>
            <td><b>{l s='Reference' mod='quotation'}</b></td>
            <td>{$quotation_details.form_name|escape:'htmlall':'UTF-8'}</td>
        </tr>
        <tr>
            <td><b>{l s='Client' mod='quotation'}</b></td>
            <td>
                {if $quotation_details.id_customer > 0}
                    {$quotation_details.id_customer|escape:'htmlall':'UTF-8'}
                {else}
                    {l s='Visitor' mod='quotation'}
                {/if}</td>
        </tr>
        {if isset($employee)}
            <tr>
                <td><b>{l s='Employee' mod='quotation'}</b></td>
                <td>{$employee|escape:'htmlall':'UTF-8'}</td>
            </tr>
        {/if}
        <tr>
            <td><b>{l s='Statut' mod='quotation'}</b></td>
            <td>
                {if $is_customer}
                    {$quotation_details.value|escape:'htmlall':'UTF-8'}
                {else}
                    {if $quotation_details.id_statut neq 6}
                        <select id="quotation-statut-{$quotation_details.id_quot|escape:'htmlall':'UTF-8'}" class="quotation-statut" data-quotation-id="{$quotation_details.id_quot|escape:'htmlall':'UTF-8'}">
                        {foreach from=$statuts item=statut}
                            <option value="{$statut.id_statut|escape:'htmlall':'UTF-8'}"
                            {if $statut.id_statut eq $quotation_details.id_statut}
                            selected="selected"
                            {/if}>
                                {$statut.value|escape:'htmlall':'UTF-8'}
                            </option>
                        {/foreach}
                        </select>
                        {else}
                            {$statuts.5.value|escape:'htmlall':'UTF-8'}
                        {/if}
                {/if}
            </td>
        </tr>
        <tr>
            <td><b>{l s='Number of articles' mod='quotation'}</b></td>
            <td>{$total_product|escape:'htmlall':'UTF-8'}</td>
        </tr>
    </table>
</div>
<div id="quotation_articles_list" class="quotation_row">
    <h3>{l s='Articles list' mod='quotation'}</h3>
    <table class="display table">
        <tbody>
            {foreach from=$quotation_products item=product}
                <tr>
                    <td><a class="cart-images" href="{$product.link|escape:'htmlall':'UTF-8'}" title="{$product.name|escape:'htmlall':'UTF-8'}"><img src="{$product.img|escape:'htmlall':'UTF-8'}" alt="{$product.name|escape:'htmlall':'UTF-8'}"></a></td>
                    <td><span class="quantity-formated"><span class="quantity">{$product.quantity|escape:'htmlall':'UTF-8'}</span>&nbsp;x&nbsp;</span><a class="quotation_block_product_name" href="{$product.link|escape:'htmlall':'UTF-8'}" title="{$product.name|escape:'htmlall':'UTF-8'}">{$product.name|escape:'htmlall':'UTF-8'}</a>
                    </td><td style="text-align: right;">
                    <span class="price">{$product.price|escape:'htmlall':'UTF-8'} {$currency_sign|escape:'htmlall':'UTF-8'} {if $tax eq 1}{l s='Without taxes' mod='quotation'}{else}{l s='With taxes' mod='quotation'}{/if}</span></td>
                </tr>
            {/foreach}
            <tr>
                <td><b>{l s='Total without discount' mod='quotation'}</b></td>
                <td colspan="2" style="text-align: right;">
                    <span id="total_quotation_witouth_discount" class="price quotation_block_total ajax_block_cart_total">{$total_cart|escape:'htmlall':'UTF-8'}</span> {$currency_sign|escape:'htmlall':'UTF-8'} {if $tax eq 1}{l s='Without taxes' mod='quotation'}{else}{l s='With taxes' mod='quotation'}{/if}
                </td>
            </tr>
            <tr id="discount_row">
                <td><b>{l s='Discount' mod='quotation'}</b></td>
                <td colspan="2" style="text-align: right;">
                    - <span id="discount_row_amount">{$reduction_amount|escape:'htmlall':'UTF-8'}</span> {$currency_sign|escape:'htmlall':'UTF-8'} {if $tax eq 1}{l s='Without taxes' mod='quotation'}{else}{l s='With taxes' mod='quotation'}{/if}
                </td>
            </tr>
            <tr>
                <td><b>{l s='Total' mod='quotation'}</b></td>
                <td colspan="2" style="text-align: right;">
                    <span id="total_quotation">{$total_quotation|escape:'htmlall':'UTF-8'}</span> {$currency_sign|escape:'htmlall':'UTF-8'} {if $tax eq 1}{l s='Without taxes' mod='quotation'}{else}{l s='With taxes' mod='quotation'}{/if}
                </td>
            </tr>
        </tbody>
    </table>
</div>
<div class="quotation_row">
    <h3>{l s='Client answers' mod='quotation'}</h3>
    <table class="display table">
        <tbody>
            {foreach from=$quotation_answers item=answer}
                <tr>
                {if $answer.type_field neq 'input_textarea'}
                    <td><b>{$answer.name|escape:'htmlall':'UTF-8'}</b></td>
                    <td>{$answer.value|escape:'htmlall':'UTF-8'}</td>
                {else}
                    <td colspan="2"><b>{$answer.name|escape:'htmlall':'UTF-8'}</b>
                    <p><br>
                    {$answer.value|escape:'htmlall':'UTF-8'}
                    </p></td>
                {/if}
                </tr>
            {/foreach}
        </tbody>
    </table>
</div>
<hr>
{if $canCreateCartRule}
    <div id="quotation_cart_rule_success" class="row hidden">
        <div class="alert alert-success" role="alert">
            <span class="glyphicon glyphicon-exclamation-sign" aria-hidden="true"></span>
            {l s='Discount and cart created successfully' mod='quotation'}
            <br>
        </div>
    </div>
    <div class="row quotation_row">
        <h3>{l s='Discount creation and quotation validation' mod='quotation'}</h3>

        <div id="status_not_2" {if $quotation_details.id_statut neq 2}class="hidden"{/if}>
            <div class="col-lg-2">
                <div class="input-group">
                    {if $currency_sign eq '$'}
                        <span class="input-group-addon"> $ {if $tax eq 1}{l s='Without taxes' mod='quotation'}{else}{l s='With taxes' mod='quotation'}{/if}</span>
                    {/if}
                    <input maxlength="27" name="cart_rule_value" id="cart_rule_value" type="text" value="{$cart_rule_value|escape:'htmlall':'UTF-8'}">
                    {if $currency_sign neq '$'}
                        <span class="input-group-addon"> {$currency_sign} {if $tax eq 1}{l s='Without taxes' mod='quotation'}{else}{l s='With taxes' mod='quotation'}{/if}</span>
                    {/if}
                </div>
            </div>
            <div class="col-md-3">
                <a onClick="createCartRule({$quotation_details.id_quot|escape:'htmlall':'UTF-8'})" id="createCartRule" class="btn btn-primary">{l s='Create discount and cart' mod='quotation'}</a>
            </div>
        </div>
        <div id="status_2"{if $quotation_details.id_statut eq 2} class="hidden"{/if}>
            <div class="alert alert-danger" role="alert">
                <span class="glyphicon glyphicon-exclamation-sign" aria-hidden="true"></span>
                {l s='You can\'t modify the quotation because of the statut: ' mod='quotation'}
                {$quotation_details.value|escape:'htmlall':'UTF-8'}
                <br>
                {l s='Please change quotation statut to "In study" in order to create discount and validate it' mod='quotation'}
            </div>
        </div>
    </div>
    <input type="hidden" name="quot_id_cart" id="quot_id_cart" value="{$quotation_details.id_cart|escape:'htmlall':'UTF-8'}">
    <input type="hidden" name="quot_id_cart_rule" id="quot_id_cart_rule"  value="{$quotation_details.id_cart_rule|escape:'htmlall':'UTF-8'}">
    <input type="hidden" name="tax" id="tax"  value="{$tax|escape:'htmlall':'UTF-8'}">
    <input type="hidden" name="id_currency" id="id_currency"  value="{$id_currency|escape:'htmlall':'UTF-8'}">
{/if}
<div class="row quotation_row">
    {if isset($can_modify) and $can_modify}
        <div class="col-md-1 pull-left">
            <a onClick="modifyQuotation({$quotation_details.id_quot|escape:'htmlall':'UTF-8'})" id="modifyQuotation" data-quotation-id="{$quotation_details.id_quot|escape:'htmlall':'UTF-8'}" class="btn btn-primary">{l s='Modify quotation' mod='quotation'}</a>
        </div>
    {/if}
    {if $is_customer and $quotation_details.id_statut eq 3}
        <div class="col-md-1 pull-right" style="margin-right: 50px;">
            <a id="checkoutQuotation" data-cart-id="" class="btn btn-primary quotation_checkout">{l s='Checkout quotation' mod='quotation'}</a>
        </div>
    {/if}
</div>
