{*
* 2007-2015 PrestaShop
*
* NOTICE OF LICENSE
*
* This source file is subject to the Academic Free License (AFL 3.0)
* that is bundled with this package in the file LICENSE.txt.
* It is also available through the world-wide-web at this URL:
* http://opensource.org/licenses/afl-3.0.php
* If you did not receive a copy of the license and are unable to
* obtain it through the world-wide-web, please send an email
* to license@prestashop.com so we can send you a copy immediately.
*
* DISCLAIMER
*
* Do not edit or add to this file if you wish to upgrade PrestaShop to newer
* versions in the future. If you wish to customize PrestaShop for your
* needs please refer to http://www.prestashop.com for more information.
*
*  @author    PrestaShop SA <contact@prestashop.com>
*  @copyright 2007-2015 PrestaShop SA
*  @license   http://opensource.org/licenses/afl-3.0.php  Academic Free License (AFL 3.0)
*  International Registered Trademark & Property of PrestaShop SA
*
* Don't forget to prefix your containers with your own identifier
* to avoid any conflicts with others containers.
*}
<script>
    var ajax_url2 = "{$quotation_url}";
    var uri = "{$uri|escape:'htmlall':'UTF-8'}";
    var quotation_error = "{l s='Error...' mod='quotation'}";
    var quotation_error_checkout = "{l s='Error while loading cart!' mod='quotation'}";
    var message_default = "{l s='Enter your text below in order to send a message to the seller...' mod='quotation'}";
    var order_link = "{$order_link|escape:'htmlall':'UTF-8'}";
</script>
{capture name=path}
<a href="{$link->getPageLink('my-account', true)|escape:'html':'UTF-8'}">
    {l s='My account' mod='quotation'}
</a>
<span class="navigation-pipe">{$navigationPipe}</span>
<span class="navigation_page">{l s='My quotations' mod='quotation'}</span>
{/capture}
<h1 class="page-heading bottom-indent">{l s='Quotation list' mod='quotation'}</h1>
<p class="info-title">{l s='Here are the quotations you\'ve placed since your account was created.' mod='quotation'}</p>
<table id="quotation_list" class="table table-bordered footab default footable-loaded footable">
    <thead>
        <th>ID</th>
        <th>{l s='Quotation ref' mod='quotation'}</th>
        <th>{l s='Status' mod='quotation'}</th>
        <th>{l s='Unread messages' mod='quotation'}</th>
        <th>{l s='Action' mod='quotation'}</th>
    </thead>
    {if !empty($quotations)}
    {foreach from=$quotations item=quotation}
        <tr>
            <td>{$quotation.id_quot|escape:'htmlall':'UTF-8'}</td>
            <td>{$quotation.form_name|escape:'htmlall':'UTF-8'}</td>
            <td>
                <span class="label" style="background-color:{$quotation.statut_color|escape:'htmlall':'UTF-8'}; border-color:{$quotation.statut_color|escape:'htmlall':'UTF-8'};">
                    {$quotation.statut_value|escape:'htmlall':'UTF-8'}
                </span>
            </td>
            <td id="unread_{$quotation.id_quot|escape:'htmlall':'UTF-8'}">{$quotation.unread|escape:'htmlall':'UTF-8'}</td>
            <td width="28%">
                <a class="quotation_details btn btn-default button button-small" href="#" data-quotation-id="{$quotation.id_quot|escape:'htmlall':'UTF-8'}" data-cart-id="{$quotation.id_cart|escape:'htmlall':'UTF-8'}">
                    <span>
                        {l s='Details' mod='quotation'}<i class="icon-chevron-right right"></i>
                    </span>
                </a>
                {if $quotation.id_cart > 0 and $quotation.id_statut eq 3}
                    <a class="quotation_checkout btn btn-default button button-small" href="#" data-cart-id="{$quotation.id_cart|escape:'htmlall':'UTF-8'}">
                        <span>
                            <i class="fa fa-shopping-cart"></i> {l s='checkout' mod='quotation'}
                        </span>
                    </a>
                {/if}
                {if $quotation.id_statut eq 7 or $quotation.id_statut eq 1}
                    <a class="quotation_modify btn btn-default button button-small" href="#" data-cart-id="{$quotation.id_quot|escape:'htmlall':'UTF-8'}" onClick="modifyQuotation({$quotation.id_quot|escape:'htmlall':'UTF-8'})">
                        <span>
                            <i class="fa fa-pencil-square-o"></i>{l s='Edit' mod='quotation'}
                        </span>
                    </a>
                {else}
                    <div class="tooltip">
                    <a class="quotation_modify btn btn-default button button-small" href="#" data-cart-id="{$quotation.id_quot|escape:'htmlall':'UTF-8'}" onClick="modifyQuotation({$quotation.id_quot|escape:'htmlall':'UTF-8'})" disabled>
                        <span class="tooltiptext">{l s='You cannot edit anymore this quotation' mod='quotation'}</span>
                        <span>
                            <i class="fa fa-pencil-square-o"></i>{l s='Edit' mod='quotation'}
                        </span>
                    </a>
                    </div>
                {/if}
                <div class="tooltip">
                <a class="quotation_cancel btn btn-danger btn-xs" href="" data-quotation-id="{$quotation.id_quot|escape:'htmlall':'UTF-8'}" data-cart-id="{$quotation.id_cart|escape:'htmlall':'UTF-8'}" {if $quotation.id_statut eq 5}disabled{/if}>
                    <span class="tooltiptext">{l s='Cancel quotation' mod='quotation'}</span>
                    <span>
                        <i class="icon-trash"></i>
                    </span>
                </a>
                </div>
            </td>
        </tr>
    {/foreach}
    {else}
        <tr>
            <td colspan="5">{l s='You have no quotation.' mod='quotation'}</td>
        </tr>
    {/if}
</table>
<div id="quotation_details" class="container hidden">
    <div>
        <a id="quotation_details_close" class="btn btn-default">{l s='Back to quotation list' mod='quotation'}</a>
        <a id="quotation_details_back" class="btn btn-default hidden">{l s='Back to quotation details' mod='quotation'}</a>
        <a id="quotation_messages" quotation-id="" class="btn btn-default pull-right">{l s='Send/View messages' mod='quotation'}(<span id="quotation_unread_messages">0</span>)</a>
    </div>
    <div id="quotation_details_content">

    </div>
    <div id="messages_list" class="container hidden">
        <br>
        <div id="messages_list_content">
        </div>
        <textarea id="quotation-message" name="quotation-message">
            {l s='Enter your text below in order to send a message to the seller...' mod='quotation'}
        </textarea>
        <br>
        <center><button id="sendMessage" type="button" class="btn btn-default btn-large">{l s='Send' mod='quotation'}</button></center>
    </div>
    <br/>
</div>
<ul class="footer_links clearfix">
    <li>
        <a class="btn btn-default button button-small" href="{$link->getPageLink('my-account', true)|escape:'html':'UTF-8'}">
            <span>
                <i class="icon-chevron-left"></i> {l s='Back to Your Account' mod='quotation'}
            </span>
        </a>
    </li>
    <li>
        <a class="btn btn-default button button-small" href="{$base_dir}">
            <span><i class="icon-chevron-left"></i> {l s='Home' mod='quotation'}</span>
        </a>
    </li>
</ul>
