{*
* 2007-2015 PrestaShop
*
* NOTICE OF LICENSE
*
* This source file is subject to the Academic Free License (AFL 3.0)
* that is bundled with this package in the file LICENSE.txt.
* It is also available through the world-wide-web at this URL:
* http://opensource.org/licenses/afl-3.0.php
* If you did not receive a copy of the license and are unable to
* obtain it through the world-wide-web, please send an email
* to license@prestashop.com so we can send you a copy immediately.
*
* DISCLAIMER
*
* Do not edit or add to this file if you wish to upgrade PrestaShop to newer
* versions in the future. If you wish to customize PrestaShop for your
* needs please refer to http://www.prestashop.com for more information.
*
*  @author    PrestaShop SA <contact@prestashop.com>
*  @copyright 2007-2015 PrestaShop SA
*  @license   http://opensource.org/licenses/afl-3.0.php  Academic Free License (AFL 3.0)
*  International Registered Trademark & Property of PrestaShop SA
*
* Don't forget to prefix your containers with your own identifier
* to avoid any conflicts with others containers.
*}
<script>
    var quotation_error_update_statut = "{l s='Error while updating quotation status!' mod='quotation'}";
    var quotation_error_update_add_cart = "{l s='You cannot send an empty quote, please add a product!' mod='quotation'}";
    var quotation_error_update = "{l s='Error while updating the quotation!' mod='quotation'}";
    var quotation_error_save = "{l s='Error while saving the quotation!' mod='quotation'}";
    var quotation_error = "{l s='Error...' mod='quotation'}";
</script>

{capture name=path}
<span class="navigation_page">{l s='My quotation' mod='quotation'}</span>
{/capture}
{if $logged eq 1} {* IF THE USER IS CONNECTED DISPLAY CART QUOTATION *}
{if $total_product > 0} {* IF THE USER IS CONNECTED DISPLAY CART QUOTATION *}
<div id="content">
<h1 id="cart_title" class="page-heading">{l s='Quotation-cart summary' mod='quotation'}
    <span class="heading-counter">{l s='Your quotation cart contains : ' mod='quotation'} <b id="total_product">{$total_product|escape:'htmlall':'UTF-8'}</b> {if $total_product eq 1}{l s='product' mod='quotation'}{else}{l s='products' mod='quotation'}{/if}
        {* <span id="summary_products_quantity">{$productNumber} {if $productNumber == 1}{l s='product'}{else}{l s='products'}{/if}</span> *}
    </span>
</h1>

<div id="order-detail-content" class="table_block table-responsive">
    <table id="cart_summary" class="table table-bordered {if $PS_STOCK_MANAGEMENT}stock-management-on{else}stock-management-off{/if}">
        <thead>
            <tr>
                <th class="cart_product first_item">{l s='Product' mod='quotation'}</th>
                <th class="cart_description item">{l s='Description' mod='quotation'}</th>
                <th class="cart_unit item text-right">{l s='Unit price' mod='quotation'}</th>
                <th class="cart_quantity item text-center">{l s='Qty' mod='quotation'}</th>
                {* {if $PS_CATALOG_MODE eq 0} *}
                    {if $tax eq 1}{l s='Without taxes' mod='quotation'}
                        <th class="cart_total item text-right">{l s='Total)' mod='quotation'}</th>
                    {else}
                        <th class="cart_total item text-right">{l s='Total (with taxes)' mod='quotation'}</th>
                    {/if}
                {* {/if} *}
            </tr>
        </thead>
        <tfoot>
            <tr>
                <td colspan="2"></td>
                <td colspan="2" class="total_price_container text-right"><span>{l s='Total' mod='quotation'}</span></td>
                <td colspan="1" class="total_quotation">{$currency_sign|escape:'htmlall':'UTF-8'} <span id="total_amount_cart">{$total_cart|escape:'htmlall':'UTF-8'}</span></td>
            </tr>
        </tfoot>
        <tbody>
            {foreach from=$quotation_products item=product}
                <tr id="product_{$product.id_product|escape:'htmlall':'UTF-8'}_{$product.id_combination|escape:'htmlall':'UTF-8'}">
                    <td class="cart-images-quotation"><a href="{$product.link|escape:'htmlall':'UTF-8'}" title="{$product.name|escape:'htmlall':'UTF-8'}"><img src="{$product.img|escape:'htmlall':'UTF-8'}" alt="{$product.name|escape:'htmlall':'UTF-8'}" style="border: 1px solid #d6d4d4;"></a></td>
                    <td class="cart_description">
                        <p class="product-name"><a class="quotation_block_product_name" href="{$product.link|escape:'htmlall':'UTF-8'}" title="{$product.name|escape:'htmlall':'UTF-8'}">{$product.name|escape:'htmlall':'UTF-8'}</a></p>
                        <small class="cart_ref">REF : {$product.reference|escape:'htmlall':'UTF-8'}</small>
                        <small>{$product.combination_name|escape:'htmlall':'UTF-8'}</small>
                    </td>
                    <td style="text-align:right;">{$product.unit_price|escape:'htmlall':'UTF-8'} {$currency_sign|escape:'htmlall':'UTF-8'}</td>
                    <td id="quantity" style="text-align:center;">{$product.quantity|escape:'htmlall':'UTF-8'}</td>
                    {* {if $PS_CATALOG_MODE eq 0} *}
                        <td style="text-align:right;">
                        <span class="price">{$product.price|escape:'htmlall':'UTF-8'} {$currency_sign|escape:'htmlall':'UTF-8'}
                        </span>
                        </td>
                    {* {/if} *}
                </tr>
            {/foreach}
            {* {if $PS_CATALOG_MODE eq 0}
            <tr>
                <td><b>{l s='Total' mod='quotation'}</b></td>
                <td colspan="2" style="text-align: right;"><span class="price quotation_block_total ajax_block_cart_total"><b>{$total_product|escape:'htmlall':'UTF-8'}</b> {$currency_sign|escape:'htmlall':'UTF-8'} {if $tax eq 1}{l s='Without taxes' mod='quotation'}{else}{l s='With taxes' mod='quotation'}{/if}</span></td>
            </tr>
            {/if} *}
        </tbody>
    </table>
</div>

<h1 class="page-heading">{l s='Form' mod='quotation'}</h1>

<div id="quotation-front-form" class="quotation-front-form form-group">
    {$form}
</div>

<input type="hidden" id="id_form_quotation" value="{$id_form|escape:'htmlall':'UTF-8'}">
<input type="hidden" id="id_quotation" value="{$id_quot|escape:'htmlall':'UTF-8'}">

{* <center><button id="sendQuotation" type="submit" class="btn">{l s='Send quotation' mod='quotation'}</button></center> *}

<center><div id="quotation_loader" class="quotation_loader hidden"><img src="modules/quotation/img/loader.gif"></div></center>

{* BOTTOM BUTTON *}
<div style="border-bottom: 1px solid #d6d4d4;margin-bottom:15px;margin-top:15px"></div>

<p class="cart_navigation clearfix">
<a href="javascript:history.back()" title="{l s='Previous'}" class="button-exclusive btn btn-default">
    <i class="icon-chevron-left"></i>
    {l s='Continue shopping' mod='quotation'}
</a>
    <button id="sendQuotation" type="submit" data-show-if-js="" style="" id="confirmOrder" type="button" class="button btn btn-default standard-checkout button-medium"><span>{l s='Send quotation' mod='quotation'}</span></button>
</p>
</div>

{else}
<div class="alert alert-danger" role="alert">
    <span class="glyphicon glyphicon-exclamation-sign" aria-hidden="true"></span>
    <span class="sr-only">{l s='Error:' mod='quotation'}</span>
    {l s='You have not add product to the quotation yet. Please add at least one product.' mod='quotation'}
</div>
<div style="border-bottom: 1px solid #d6d4d4;margin-bottom:15px;margin-top:15px"></div>
<p class="cart_navigation clearfix">
    <a href="{$base_dir}" title="{l s='Previous'}" class="button-exclusive btn btn-default">
        <i class="icon-chevron-left"></i>
        {l s='Continue shopping' mod='quotation'}
    </a>
</p>
{/if}

{else} {* IF THE USER IS NOT CONNECTED DISPLAY ERROR MESSAGE *}
<div class="alert alert-danger" role="alert">
    <span class="glyphicon glyphicon-exclamation-sign" aria-hidden="true"></span>
    <span class="sr-only">{l s='Error:' mod='quotation'}</span>
    {l s='Please connect or create an account to send your quotation.' mod='quotation'}
</div>
<div style="border-bottom: 1px solid #d6d4d4;margin-bottom:15px;margin-top:15px"></div>
<p class="cart_navigation clearfix">
<a href="javascript:history.back()" title="{l s='Previous' mod='quotation'}" class="button-exclusive btn btn-default">
    <i class="icon-chevron-left"></i>
    {l s='Continue shopping' mod='quotation'}
</a>
</p>
{/if}

<div id="no_product" class="hidden">
<div class="alert alert-danger" role="alert">
    <span class="glyphicon glyphicon-exclamation-sign" aria-hidden="true"></span>
    <span class="sr-only">{l s='Error:' mod='quotation'}</span>
    {l s='You have not add product to the quotation yet. Please add at least one product.' mod='quotation'}
</div>
<div style="border-bottom: 1px solid #d6d4d4;margin-bottom:15px;margin-top:15px"></div>
<p class="cart_navigation clearfix">
    <a href="{$base_dir}" title="{l s='Previous' mod='quotation'}" class="button-exclusive btn btn-default">
        <i class="icon-chevron-left"></i>
        {l s='Continue shopping' mod='quotation'}
    </a>
</p>
</div>
