{*
* 2007-2015 PrestaShop
*
* NOTICE OF LICENSE
*
* This source file is subject to the Academic Free License (AFL 3.0)
* that is bundled with this package in the file LICENSE.txt.
* It is also available through the world-wide-web at this URL:
* http://opensource.org/licenses/afl-3.0.php
* If you did not receive a copy of the license and are unable to
* obtain it through the world-wide-web, please send an email
* to license@prestashop.com so we can send you a copy immediately.
*
* DISCLAIMER
*
* Do not edit or add to this file if you wish to upgrade PrestaShop to newer
* versions in the future. If you wish to customize PrestaShop for your
* needs please refer to http://www.prestashop.com for more information.
*
*  @author    PrestaShop SA <contact@prestashop.com>
*  @copyright 2007-2015 PrestaShop SA
*  @license   http://opensource.org/licenses/afl-3.0.php  Academic Free License (AFL 3.0)
*  International Registered Trademark & Property of PrestaShop SA
*
* Don't forget to prefix your containers with your own identifier
* to avoid any conflicts with others containers.
*}
<script>
    var ajax_url = "{$quotation_url}";
    var quotation_url_customerQuotations = "{$quotation_url_customerQuotations}";
</script>
<div class="col-sm-3">
    <div class="quotation_block">
        <a>
        <b>{l s='Quotation' mod='quotation'}</b>
        <span id="quotation_quantity">{$total_product|escape:'htmlall':'UTF-8'}</span>
        <span class="quotation_product_txt">{l s='Product' mod='quotation'}</span>
        <span class="quotation_product_txt_s unvisible">{l s='Products' mod='quotation'}</span>
        </a>
        <div class="quotation_inner_block block exclusive" style="display: none;">
            <div class="block_content">
                <!-- block list of products -->
                <div class="quotation_inner_block_list">
                    {if !$quotation_has_product}
                    <p class="quotation_inner_block_no_products">
                        {l s='No product' mod='quotation'}
                    </p>
                    {else}
                    <dl class="products">
                        {foreach from=$quotation_products item=product}
                            <dt id="quotation_block_product_{$product.id_product|escape:'htmlall':'UTF-8'}_{$product.id_combination|escape:'htmlall':'UTF-8'}" data-id="quotation_block_product_{$product.id_product|escape:'htmlall':'UTF-8'}_{$product.id_combination|escape:'htmlall':'UTF-8'}" class="first_item">
                                <a class="cart-images" href="{$product.link|escape:'htmlall':'UTF-8'}" title="{$product.name|escape:'htmlall':'UTF-8'}"><img src="{$product.img|escape:'htmlall':'UTF-8'}" alt="{$product.name|escape:'htmlall':'UTF-8'}"></a>
                                <div class="cart-info">
                                    <div class="product-name">
                                        <span class="quantity-formated"><span id="quantity_{$product.id_product|escape:'htmlall':'UTF-8'}_{$product.id_combination|escape:'htmlall':'UTF-8'}" class="quantity">{$product.quantity|escape:'htmlall':'UTF-8'}</span>&nbsp;x&nbsp;</span><a class="quotation_block_product_name" href="{$product.link|escape:'htmlall':'UTF-8'}" title="{$product.name|escape:'htmlall':'UTF-8'}">{$product.name|escape:'htmlall':'UTF-8'}</a>
                                    </div>
                                    {if $PS_CATALOG_MODE eq 0}<span class="price"><span id="price_{$product.id_product|escape:'htmlall':'UTF-8'}_{$product.id_combination|escape:'htmlall':'UTF-8'}">{$product.price|escape:'htmlall':'UTF-8'}</span> {$currency_sign|escape:'htmlall':'UTF-8'}</span>{/if}
                                </div>
                                <span class="remove_link">
                                    <a class="ajax_quotation_block_remove_link" rel="nofollow" onClick="quotationRemoveProduct({$product.id_product|escape:'htmlall':'UTF-8'}, {$product.id_combination|escape:'htmlall':'UTF-8'})">&nbsp;</a>
                                </span>
                            </dt>
                        {/foreach}
                    </dl>
                    {/if}
                    <p class="quotation_block_no_products unvisible">Aucun produit</p>
                    {if $PS_CATALOG_MODE eq 0}
                    <div class="cart-prices">
                        <div class="cart-prices-line last-line">
                            <span id="quotation_block_total" class="price quotation_block_total">{$total_cart|escape:'htmlall':'UTF-8'}</span> {$currency_sign|escape:'htmlall':'UTF-8'}
                            <span>{l s='Total' mod='quotation'} {$tax_text|escape:'htmlall':'UTF-8'}</span>
                        </div>
                    </div>
                    {/if}
                    <p class="cart-buttons">
                        <a id="button_order_cart" class="btn btn-default button button-small" href="{$quotation_url|escape:'htmlall':'UTF-8'}" title="Commander" rel="nofollow">
                            <span>
                                {l s='Ask for a quotation' mod='quotation'}<i class="icon-chevron-right right"></i>
                            </span>
                        </a>
                    </p>
                </div>
            </div>
        </div><!-- .quotation_block -->
    </div>
</div>
