/*
*
* NOTICE OF LICENSE
*
* This source file is subject to the Open Software License (OSL 3.0)
* that is bundled with this package in the file LICENSE.txt.
* It is also available through the world-wide-web at this URL:
* http://opensource.org/licenses/osl-3.0.php
* If you did not receive a copy of the license and are unable to
* obtain it through the world-wide-web, please send an email
* to license@prestashop.com so we can send you a copy immediately.
*
* DISCLAIMER
*
* Do not edit or add to this file if you wish to upgrade PrestaShop to newer
* versions in the future. If you wish to customize PrestaShop for your
* needs please refer to http://www.prestashop.com for more information.
*
*  @author    PrestaShop SA <contact@prestashop.com>
*  @copyright 2007-2018 PrestaShop SA
*  @license   http://opensource.org/licenses/osl-3.0.php  Open Software License (OSL 3.0)
*  International Registered Trademark & Property of PrestaShop SA
*/

function initMarkers()
{
	searchUrl += '?ajax=1&all=1';
	downloadUrl(searchUrl, function(data) {
		var xml = parseXml(data);
		var markerNodes = xml.documentElement.getElementsByTagName('marker');
		var bounds = new google.maps.LatLngBounds();
		for (var i = 0; i < markerNodes.length; i++)
		{
			var name = markerNodes[i].getAttribute('name');
			var address = markerNodes[i].getAttribute('address');
			var addressNoHtml = markerNodes[i].getAttribute('addressNoHtml');
			var other = markerNodes[i].getAttribute('other');
			var id_store = markerNodes[i].getAttribute('id_store');
			var has_store_picture = markerNodes[i].getAttribute('has_store_picture');
			var latlng = new google.maps.LatLng(
			parseFloat(markerNodes[i].getAttribute('lat')),
			parseFloat(markerNodes[i].getAttribute('lng')));
			createMarker(latlng, name, address, other, id_store, has_store_picture);
			bounds.extend(latlng);
		}
	});
}

function searchLocations()
{
	$('#stores_loader').show();
	var address = document.getElementById('addressInput').value;
	var geocoder = new google.maps.Geocoder();
	geocoder.geocode({address: address}, function(results, status) {
		if (status === google.maps.GeocoderStatus.OK){
			searchLocationsNear(results[0].geometry.location);
		}else
			alert(address+' '+translation_6);
		$('#stores_loader').hide();
	});
}

function clearLocations(n)
{
	infoWindow.close();
	for (var i = 0; i < markers.length; i++)
		markers[i].setMap(null);
		
	markers.length = 0;
$(locationSelect).show();
	locationSelect.innerHTML = '';
	var option = document.createElement('option');
	option.value = 'none';
	if (!n)
		option.innerHTML = translation_1;
	else
	{
		if (n === 1)
			option.innerHTML = '1'+' '+translation_2;
		else
			option.innerHTML = n+' '+translation_3;
	}
	locationSelect.appendChild(option);
	$('#stores-table tr.node').remove();
}

function searchLocationsNear(center)
{
	var radius = document.getElementById('radiusSelect').value;
	var productID = $('#fmeSearchProduct').attr('name');
	if (typeof(productID) == 'undefined' || productID == null) { productID = '';}
	var searchUrl = baseUri+'?controller=stores&ajax=1&latitude=' + center.lat() + '&longitude=' + center.lng() + '&radius=' + radius+'&product='+productID;
	downloadUrl(searchUrl, function(data) {
		var xml = parseXml(data);
		var markerNodes = xml.documentElement.getElementsByTagName('marker');
		var bounds = new google.maps.LatLngBounds();

		clearLocations(markerNodes.length);
		for (var i = 0; i < markerNodes.length; i++)
		{
			var name = markerNodes[i].getAttribute('name');
			var address = markerNodes[i].getAttribute('address');
			var addressNoHtml = markerNodes[i].getAttribute('addressNoHtml');
			var other = markerNodes[i].getAttribute('other');
			var distance = parseFloat(markerNodes[i].getAttribute('distance'));
			var id_store = parseFloat(markerNodes[i].getAttribute('id_store'));
			var phone = markerNodes[i].getAttribute('phone');
			var has_store_picture = markerNodes[i].getAttribute('has_store_picture');
			var latlng = new google.maps.LatLng(
			parseFloat(markerNodes[i].getAttribute('lat')),
			parseFloat(markerNodes[i].getAttribute('lng')));

			createOption(name, distance, i);
			createMarker(latlng, name, address, other, id_store, has_store_picture);
			bounds.extend(latlng);

			$('#stores-table tr:last').after('<tr class="node"><td class="num">'+parseInt(i + 1)+'</td><td><b>'+name+'</b>'+(has_store_picture === 1 ? '<br /><img src="'+img_store_dir+parseInt(id_store)+'-medium.jpg" alt="" />' : '')+'</td><td>'+address+(phone !== '' ? '<br /><br />'+translation_4+' '+phone : '')+'</td><td class="distance">'+distance+' '+distance_unit+'</td></tr>');
			$('#stores-table').show();
		}

		if (markerNodes.length)
		{
			map.fitBounds(bounds);
			var listener = google.maps.event.addListener(map, "idle", function() { 
				if (map.getZoom() > 13) map.setZoom(13);
				google.maps.event.removeListener(listener); 
			});
		}
		locationSelect.style.visibility = 'visible';
		$(locationSelect).show();
		locationSelect.onchange = function() {
			var markerNum = locationSelect.options[locationSelect.selectedIndex].value;
			google.maps.event.trigger(markers[markerNum], 'click');
		};
	});
}

function createMarker(latlng, name, address, other, id_store, has_store_picture)
{
	var html = '<b>'+name+'</b><br/>'+address+(has_store_picture > 0 ? '<br /><img src="'+img_store_dir+parseInt(id_store)+'-medium_default.jpg" alt="" style="max-width:200px" />' : '')+other+'<br /><a href="http://maps.google.com/maps?saddr=&daddr='+latlng+'" target="_blank">'+translation_5+'<\/a>';
	var image = new google.maps.MarkerImage(img_ps_dir+logo_store);
	var marker = '';

	if (hasStoreIcon)
		marker = new google.maps.Marker({ map: map, icon: image, position: latlng });
	else
		marker = new google.maps.Marker({ map: map, position: latlng });
	google.maps.event.addListener(marker, 'click', function() {
		infoWindow.setContent(html);
		infoWindow.open(map, marker);
	});
	
	markers.push(marker);
	google.maps.event.addListenerOnce(map, 'tilesloaded', function() {
		$('select#locationSelect > option[label="'+CurrentUrl+'"]').prop('selected',true);
		$('select#locationSelect').trigger('change');
	// google.maps.event.trigger(markers[CurrentUrl], 'click');
	
	})
}

function createOption(name, distance, num)
{
	var option = document.createElement('option');
	option.value = num;
	option.innerHTML = name+' ('+distance.toFixed(1)+' '+distance_unit+')';
	locationSelect.appendChild(option);
}

function downloadUrl(url, callback)
{
	var request = window.ActiveXObject ?
	new ActiveXObject('Microsoft.XMLHTTP') :
	new XMLHttpRequest();

	request.onreadystatechange = function() {
		if (request.readyState === 4) {
			request.onreadystatechange = doNothing;
			callback(request.responseText, request.status);
		}
	};

	request.open('GET', url, true);
	request.send(null);
}

function parseXml(str)
{
	if (window.ActiveXObject) {
		var doc = new ActiveXObject('Microsoft.XMLDOM');
		doc.loadXML(str);
		return doc;
	}
	else if (window.DOMParser) {
		return (new DOMParser()).parseFromString(str, 'text/xml');
	}
}

function doNothing() {}

$(document).ready(function()
{
	map = new google.maps.Map(document.getElementById('map'), {
		center: new google.maps.LatLng(defaultLat, defaultLong),
		zoom: defaultZoom,
		mapTypeId: 'roadmap',
		mapTypeControlOptions: {style: google.maps.MapTypeControlStyle.DROPDOWN_MENU}
	});
	infoWindow = new google.maps.InfoWindow();

	locationSelect = document.getElementById('locationSelect');
	$('#locationSelect').hide();
		locationSelect.onchange = function() {
		var markerNum = locationSelect.options[locationSelect.selectedIndex].value;
		if (markerNum !== 'none')
		google.maps.event.trigger(markers[markerNum], 'click');
	};
	
	$('#addressInput').keypress(function(e) {
		code = e.keyCode ? e.keyCode : e.which;
		if(code.toString() === 13)
			searchLocations();
	});
google.maps.event.addListenerOnce(map, 'tilesloaded', function() {
//IF autolocation is enabled ask user's Permission
	if(autolocateUser){
		navigator.geolocation.getCurrentPosition(PosLoc, PosUnSuccess);
	}
});
	initMarkers();
});

	function PosLoc(position) {
    // Centre the map on the new location
    var coords = position.coords || position.coordinate || position;
    var LtLnPos = new google.maps.LatLng(coords.latitude, coords.longitude);
    map.setCenter(LtLnPos);
    map.setZoom(10);
    var marker = new google.maps.Marker({
	    map: map,
	    position: LtLnPos,
	    title: translation_06
    });
	markers.push(marker);

    // And reverse geocode.
    (new google.maps.Geocoder()).geocode({latLng: LtLnPos}, function(resp) {
		  var place = translation_07; //You're around here somewhere!
		  if (resp[0]) {
			  var bits = [];
			  for (var i = 0, I = resp[0].address_components.length; i < I; ++i) {
				  var component = resp[0].address_components[i];
				  if (jQuery.inArray(component.types, 'political')) {
					  bits.push(component.long_name);
					}
				}
				if (bits.length) {
					place = bits;
				}
				marker.setTitle(resp[0].formatted_address);
			}
			document.getElementById('addressInput').value = place;
			map.setZoom(5);
	  });
}
  
function PosUnSuccess(issue) {
    var message;
    switch(issue.code) {
      case issue.UNKNOWN_ERROR:
        message = translation_01; // Unable to find your location
        break;
      case issue.PERMISSION_DENINED:
        message = translation_02; //Permission denied
        break;
      case issue.POSITION_UNAVAILABLE:
        message = translation_03; //Your location unknown
        break;
      case issue.BREAK:
        message = translation_04; //Timeout error
        break;
      default:
        message = translation_05; //Location detection not supported in browser
    }
}

//Reset MAP
function ResetMap(n)
{
	infoWindow.close();
	map.setZoom(10);
	initMarkers();
	 var LtLnPos = new google.maps.LatLng(defaultLat, defaultLong);
    map.setCenter(LtLnPos);

	locationSelect.innerHTML = '';
	var option = document.createElement('option');
	option.value = 'none';
	if (!n)
		option.innerHTML = translation_1;
	else
	{
		if (n === 1)
			option.innerHTML = '1'+' '+translation_2;
		else
			option.innerHTML = n+' '+translation_3;
	}
	locationSelect.appendChild(option);
	$('#stores-table tr.node').remove();
	$('#locationSelect').hide();
}
$(document).ready(function () {
var $_slWidget = $('#storelocator_widget');
var $_slBox    = $_slWidget.find('input[type=text]');
var sl_url     = $_slWidget.attr('data-url');

$.widget('prestashop.psSlAutocomplete', $.ui.autocomplete, {
	_renderItem: function (ul, product) {
		return $("<li>")
			.append($("<a>")
				.append($("<span>").html(product.category_name).addClass("category"))
				.append($("<span>").html(' > ').addClass("separator"))
				.append($("<span>").html(product.name).addClass("product"))
			).appendTo(ul)
		;
	}
});

$_slBox.psSlAutocomplete({
	source: function (query, response) {
		$.get(sl_url, {
			s: query.term,
			resultsPerPage: 10
		}, null, 'json')
		.then(function (resp) {
			response(resp.products);
		})
		.fail(response);
	},
	select: function (event, ui) {
		var _id_sl = ui.item.id_product;
		var _name_sl = ui.item.name;
		$('#fmeSearchProduct').attr('value', _name_sl);
		$('#fmeSearchProduct').attr('name',_id_sl);
		$('#fmeSearchProduct').attr('placeholder',_name_sl);
	   //console.log(_id_sl);
	},
});
});
