{*
*
*
* NOTICE OF LICENSE
*
* This source file is subject to the Open Software License (OSL 3.0)
* that is bundled with this package in the file LICENSE.txt.
* It is also available through the world-wide-web at this URL:
* http://opensource.org/licenses/osl-3.0.php
* If you did not receive a copy of the license and are unable to
* obtain it through the world-wide-web, please send an email
* to license@prestashop.com so we can send you a copy immediately.
*
* DISCLAIMER
*
* Do not edit or add to this file if you wish to upgrade PrestaShop to newer
* versions in the future. If you wish to customize PrestaShop for your
* needs please refer to http://www.prestashop.com for more information.
*
*  @author    FME Modules
*  @copyright 2016 FME Modules
*  @license   http://opensource.org/licenses/osl-3.0.php  Open Software License (OSL 3.0)
*  International Registered Trademark & Property of PrestaShop SA
*}

{extends file="helpers/form/form.tpl"}

{block name=script}
	$(document).ready(function() {
		$('#latitude, #longitude').keyup(function() {
			$(this).val($(this).val().replace(/,/g, '.'));
		});
    $('#store_form_submit_btn').addClass('btn btn-default pull-right');
	});
{/block}

{block name="input"}
	{if $input.type == 'latitude'}
<input type="text"
			{if isset($input.size)}size="{$input.size|escape:'htmlall':'UTF-8'}"{/if}
			{if isset($input.maxlength)}maxlength="{$input.maxlength|escape:'htmlall':'UTF-8'}"{/if}
			name="latitude"
			id="latitude"
			value="{$fields_value[$input.name]|escape:'htmlall':'UTF-8'}" />
/
<input type="text"
			{if isset($input.size)}size="{$input.size|escape:'htmlall':'UTF-8'}"{/if}
			{if isset($input.maxlength)}maxlength="{$input.maxlength|escape:'htmlall':'UTF-8'}"{/if}
			name="longitude"
			id="longitude"
			value="{$fields_value['longitude']|escape:'htmlall':'UTF-8'}" />
{elseif  $input.type == 'storeproducts'}
              {assign var=rawArray value=$input.values}
              {*$fields_value|@print_r*}
             
                <div id="productArrayTable">
                  <table cellspacing="0" cellpadding="0" class="table" style="min-width:66em; max-height:120px; overflow:scroll">
                    <tr>
                      <th> <input type="checkbox" name="checkme" id="checkme" class="noborder" onclick="checkDelBoxes(this.form, '{$input.name|escape:'htmlall':'UTF-8'}', this.checked)" />
                      </th>
                      <th>{l s='ID' mod='storelocator'}</th>
                      <th>{l s='Name' mod='storelocator'}</th>
                    </tr>
                    {foreach $rawArray as $key => $allProds}
                    {if $allProds['status'] == 1}
                    <tr {if $key%2}class="alt_row"{/if}>
                      <td> {assign var=id_checkbox value=$allProds['id_product']}
                        {*$fields_value|@print_r*}
                        <input type="checkbox" class="{$input.name|escape:'htmlall':'UTF-8'}" name="{$input.name|escape:'htmlall':'UTF-8'}" id="{$id_checkbox|escape:'htmlall':'UTF-8'}" value="{$id_checkbox|escape:'htmlall':'UTF-8'}" {if isset($fields_value[$id_checkbox])}checked="checked"{/if} /></td>
                      <td><strong>{$allProds['id_product']|escape:'htmlall':'UTF-8'}</strong></td>
                      <td><label for="{$id_checkbox|escape:'htmlall':'UTF-8'}" class="t"><strong>{$allProds['name']|escape:'none'}</strong></label></td>
                    </tr>
                    {/if}
                    {/foreach}
                  </table>
                </div>
			<style type="text/css">
				 #productArrayTable { width:754px; max-height:360px; overflow:scroll}
				 </style>
{else}
		{$smarty.block.parent}
	{/if}
{/block}

{block name="other_input"}
	{if $key == 'rightCols'}
		{foreach $field as $input}
			{if $input.type == 'file'}
<label style="text-align: left; width: inherit;width:250px;text-align:right">{$input.label|escape:'htmlall':'UTF-8'} </label>
<div class="margin-form">
  <input type="file" name="{$input.name|escape:'htmlall':'UTF-8'}" />
  <p class="clear">{$input.desc|escape:'htmlall':'UTF-8'}</p>
  {if isset($fields_value.image) && $fields_value.image}
  <div id="image" style="width:370px;"> {$fields_value.image}{*HTML Content*}
    <p align="center">{l s='File size' mod='storelocator'} {$fields_value.size|escape:'htmlall':'UTF-8'}kb</p>
    <a href="{$current|escape:'htmlall':'UTF-8'}&id_store={$form_id|escape:'htmlall':'UTF-8'}&token={$token|escape:'htmlall':'UTF-8'}&deleteImage=1"> <img src="../img/admin/delete.gif" alt="{l s='Delete' mod='storelocator'}" /> {l s='Delete' mod='storelocator'} </a> </div>
  {/if} </div>
{/if}
<table cellpadding="2" cellspacing="2" style="padding: 10px; margin: 15px 0 20px 260px; border: 1px solid #BBB;">
  <tr>
    <th colspan="2">{l s='Hours:' mod='storelocator'}</th>
  </tr>
  <tr>
    <td>&nbsp;</td>
    <td style="font-size: 0.85em;">{l s='e.g. 10:00AM - 9:30PM' mod='storelocator'}</td>
  </tr>
  {foreach $fields_value.days as $k => $value}
  <tr style="color: #7F7F7F; font-size: 0.85em;">
    <td>{$value|escape:'htmlall':'UTF-8'}</td>
    <td><input type="text" size="25" name="hours_{$k|escape:'htmlall':'UTF-8'}" value="{if isset($fields_value.hours[$k-1])}{$fields_value.hours[$k-1]|escape:'htmlall':'UTF-8'}{/if}" />
      <br /></td>
  </tr>
  {/foreach}
</table>
<div class="clear"></div>
{/foreach}
	{/if}
{/block} 