{*
*
*
* NOTICE OF LICENSE
*
* This source file is subject to the Open Software License (OSL 3.0)
* that is bundled with this package in the file LICENSE.txt.
* It is also available through the world-wide-web at this URL:
* http://opensource.org/licenses/osl-3.0.php
* If you did not receive a copy of the license and are unable to
* obtain it through the world-wide-web, please send an email
* to license@prestashop.com so we can send you a copy immediately.
*
* DISCLAIMER
*
* Do not edit or add to this file if you wish to upgrade PrestaShop to newer
* versions in the future. If you wish to customize PrestaShop for your
* needs please refer to http://www.prestashop.com for more information.
*
*  @author    FME Modules
*  @copyright 2016 FME Modules
*  @license   http://opensource.org/licenses/osl-3.0.php  Open Software License (OSL 3.0)
*  International Registered Trademark & Property of PrestaShop SA
*}

{capture name=path}{l s='Our stores' mod='storelocator'}{/capture}
<h1>{if empty($fmm_sl_pageheading)}{l s='Our stores' mod='storelocator'}{else}{$fmm_sl_pageheading|escape:'htmlall':'UTF-8'}{/if}</h1>
{if $simplifiedStoresDiplay}
	{if $stores|@count}
<p>{l s='Here you can find our store locations. Please feel free to contact us:' mod='storelocator'}</p>
{foreach $stores as $store}
<div class="store-small grid_2"> {if $store.has_picture}
  <p><img src="{$img_store_dir|escape:'htmlall':'UTF-8'}{$store.id_store|escape:'htmlall':'UTF-8'}-medium_default.jpg" alt="" width="{$mediumSize.width|escape:'htmlall':'UTF-8'}" height="{$mediumSize.height|escape:'htmlall':'UTF-8'}" /></p>
  {/if}
  <p> <b>{$store.name|escape:'htmlall':'UTF-8'}</b><br />
    {$store.address1|escape:'htmlall':'UTF-8'}<br />
    {if $store.address2}{$store.address2|escape:'htmlall':'UTF-8'}{/if}<br />
    {$store.postcode|escape:'htmlall':'UTF-8'} {$store.city|escape:'htmlall':'UTF-8'}{if $store.state}, {$store.state|escape:'htmlall':'UTF-8'}{/if}<br />
    {$store.country|escape:'htmlall':'UTF-8'}<br />
    {if $store.phone}{l s='Phone:' js=0 mod='storelocator'} {$store.phone|escape:'htmlall':'UTF-8'}{/if} </p>
  {if isset($store.working_hours)}{$store.working_hours|escape:'htmlall':'UTF-8'}{/if} </div>
{/foreach}
	{/if}
{else}
<script type="text/javascript">
		// <![CDATA[
		var map;
		var markers = [];
		var infoWindow;
		var locationSelect;

		var defaultLat = '{$defaultLat|escape:'htmlall':'UTF-8'}';
		var defaultLong = '{$defaultLong|escape:'htmlall':'UTF-8'}';
		var defaultZoom = {$fmm_sl_zoom|escape:'htmlall':'UTF-8'};
		var translation_1 = '{l s='No stores were found. Please try selecting a wider radius.' js=1 mod='storelocator'}';
		var translation_2 = '{l s='store found -- see details:' js=1 mod='storelocator'}';
		var translation_3 = '{l s='stores found -- view all results:' js=1 mod='storelocator'}';
		var translation_4 = '{l s='Phone:' js=1 mod='storelocator'}';
		var translation_5 = '{l s='Get directions' js=1 mod='storelocator'}';
		var translation_6 = '{l s='Not found' js=1 mod='storelocator'}';
		
		var translation_01 = '{l s='Unable to find your location' js=1 mod='storelocator'}';
		var translation_02 = '{l s='Permission denied' js=1 mod='storelocator'}';
		var translation_03 = '{l s='Your location unknown' js=1 mod='storelocator'}';
		var translation_04 = '{l s='Timeout error' js=1 mod='storelocator'}';
		var translation_05 = '{l s='Location detection not supported in browser' js=1 mod='storelocator'}';
		var translation_06 = '{l s='Your current Location' js=1 mod='storelocator'}';
		var translation_07 = '{l s='You are near this location' js=1 mod='storelocator'}';
		
		var hasStoreIcon = '{$hasStoreIcon|escape:'htmlall':'UTF-8'}';
		var distance_unit = '{$distance_unit|escape:'htmlall':'UTF-8'}';
		var img_store_dir = '{$img_store_dir|escape:'htmlall':'UTF-8'}';
		var img_ps_dir = '{$img_ps_dir|escape:'htmlall':'UTF-8'}';
		var searchUrl = '{$searchUrl|escape:'htmlall':'UTF-8'}';
		var logo_store = '{$logo_store|escape:'htmlall':'UTF-8'}';
		var autolocateUser = {$FMESL_USER|escape:'htmlall':'UTF-8'};
		var CurrentUrl = '{$smarty.server.HTTP_HOST|escape:'htmlall':'UTF-8'}{$smarty.server.REQUEST_URI|escape:'htmlall':'UTF-8'}';
		 CurrentUrl = location.search.split('goforstore=')[1]; //alert(CurrentUrl);
		 
	//AJAX Search Query	 
	$('document').ready( function() {
			$("#fmeSearchProduct")
				.autocomplete(
					'{$link->getPageLink('search')|addslashes|escape:'htmlall':'UTF-8'}', {
						minChars: 3,
						max: 10,
						width: 500,
						selectFirst: false,
						scroll: false,
						dataType: "json",
						formatItem: function(data, i, max, value, term) {
							return value;
						},
						parse: function(data) {
							var mytab = new Array();
							for (var i = 0; i < data.length; i++)
								mytab[mytab.length] = { data: data[i], value: data[i].cname + ' > ' + data[i].pname };
							return mytab;
						},
						extraParams: {
							ajaxSearch: 1,
							id_lang: {$cookie->id_lang|escape:'htmlall':'UTF-8'}
						}
					}
				)
				.result(function(event, data, formatted) {
					$('#fmeSearchProduct').val(data.pname);
					$('#fmeSearchProduct').attr('name',data.id_product);
					//console.log(data);
					
				})
		});
		//]]>
	</script>
<style type="text/css">
	{if $FMESL_LAYOUT == 1}{literal}body#stores #right_column { display:none !important} body#stores #center_column, body#stores #map { width:740px !important; margin-right:0px !important} {/literal} {elseif $FMESL_LAYOUT ==2}body#stores #left_column { display:none !important} body#stores #center_column, body#stores #map { width:758px !important;}{elseif $FMESL_LAYOUT ==3} {else} body#stores #left_column, body#stores #right_column { display:none !important} body#stores #center_column, body#stores #map { width:100% !important;}{/if}{literal}
	#fmeStorePage p { display:inline-block; padding-right:10px} #fmeStorePage p.clearfix { padding-bottom:0; vertical-align:middle} .fmeSearchbyProduct {border: 1px solid #CCCCCC;padding: 2px 5px; width: 190px;}
	#fmm_sl_oldversions td { padding:1px !important;}
	{/literal}
	</style>
<p>{l s='Enter a location (e.g. zip/postal code, address, city or country) in order to find the nearest stores.' mod='storelocator'}</p>
<div id="fmeStorePage">
{if $FMESL_SBP >= 1}
<p>
    <label for="addressInput">{l s='Search By Product:' mod='storelocator'}</label>
    <input type="text" id="fmeSearchProduct" value="{l s='Product Name etc. iPod nano' mod='storelocator'}" onclick="this.value='';this.name='';" class="fmeSearchbyProduct" name="" />
  </p>
{/if}
  <p>
    <label for="addressInput">{l s='Your location:' mod='storelocator'}</label>
    <input type="text" name="location" id="addressInput" value="{l s='Address, zip / postal code, city, state or country' mod='storelocator'}" onclick="this.value='';" />
  </p>
  <p>
    <label for="radiusSelect">{l s='Radius:' mod='storelocator'}</label>
    <select name="radius" id="radiusSelect">
      <option value="6371">any</option>
      <option value="15">15</option>
      <option value="25">25</option>
      <option value="50">50</option>
      <option value="100">100</option>
      <option value="500">500</option>
      <option value="1000">1000</option>
    </select>
    {$distance_unit|escape:'htmlall':'UTF-8'} <img src="{$img_ps_dir|escape:'htmlall':'UTF-8'}loader.gif" class="middle" alt="" id="stores_loader" /> </p>
  <p class="clearfix">
    <input type="button" class="button" onclick="searchLocations();" value="{l s='Search' mod='storelocator'}" style="display: inline;" />
  </p>
  {if $FMESL_RESET == 1}
   <p class="clearfix">
    <input type="button" class="button" onclick="ResetMap();" value="{l s='Reset' mod='storelocator'}" style="display: inline;" />
  </p>
  {/if}
  <div>
    <select id="locationSelect" style="visibility:visible">
    {if $stores|@count}
    <option value="none">{$stores|@count|escape:'htmlall':'UTF-8'} {l s='Stores Found' mod='storelocator'}</option>
 	{foreach from=$stores key=j item=str}
      <option value="{$j|escape:'htmlall':'UTF-8'}" label="{$str.id_store|escape:'htmlall':'UTF-8'}">{$str.id_store|escape:'htmlall':'UTF-8'}-{$str.name|escape:'htmlall':'UTF-8'}</option>
    {/foreach}
	{else}
	<option>-</option>
  {/if}
    </select>
  </div>
</div>
<div id="map"></div>
<table cellpadding="0" cellspacing="0" border="0" id="stores-table" class="table_block">
  <tr>
    <th>{l s='#' mod='storelocator'}</th>
    <th>{l s='Store' mod='storelocator'}</th>
    <th>{l s='Address' mod='storelocator'}</th>
    <th>{l s='Distance' mod='storelocator'}</th>
  </tr>
  {if $stores|@count}
  {foreach $stores as $store}
  <tr class="node">
    <td class="num">{$store.id_store|escape:'htmlall':'UTF-8'}</td>
    <td><b>{$store.name|escape:'htmlall':'UTF-8'}</b></td>
    <td>{$store.address1|escape:'htmlall':'UTF-8'}<br />
      {$store.city|escape:'htmlall':'UTF-8'}, {$store.iso_code|escape:'htmlall':'UTF-8'} {$store.postcode|escape:'htmlall':'UTF-8'}</td>
    <td class="distance" style="text-align:center"> - </td>
  </tr>
  {/foreach}
  {/if}
</table>
{/if} 