{**
 *  PrestaShop
 *
 * NOTICE OF LICENSE
 *
 * This source file is subject to the Academic Free License 3.0 (AFL-3.0)
 * that is bundled with this package in the file LICENSE.txt.
 * It is also available through the world-wide-web at this URL:
 * https://opensource.org/licenses/AFL-3.0
 * If you did not receive a copy of the license and are unable to
 * obtain it through the world-wide-web, please send an email
 * to license@prestashop.com so we can send you a copy immediately.
 *
 * DISCLAIMER
 *
 * Do not edit or add to this file if you wish to upgrade PrestaShop to newer
 * versions in the future. If you wish to customize PrestaShop for your
 * needs please refer to http://www.prestashop.com for more information.
 *
 * @author    PrestaShop SA <contact@prestashop.com>
 * @copyright  PrestaShop SA
 * @license   https://opensource.org/licenses/AFL-3.0 Academic Free License 3.0 (AFL-3.0)
 * International Registered Trademark & Property of PrestaShop SA
 *}

<div class="contact-rich">
  <h4 class="contact-title">{l s='Store information' d='Shop.Theme.Global'}</h4>
  <div class="row">
    <div class="col-lg-4 col-md-4 col-sm-4 col-sp-12">
      <div class="block">
        <div class="icon"><i class="material-icons">&#xE55F;</i></div>
        <h4 class="rich-title">{l s='Visit Us' d='Shop.Theme.Global'}</h4>
        <div class="data">{$contact_infos.address.formatted nofilter}</div>
      </div>
    </div>
    <div class="col-lg-4 col-md-4 col-sm-4 col-sp-12">
      {if $contact_infos.phone || $contact_infos.fax}
        <div class="block">
          <div class="icon"><i class="material-icons">&#xE0CD;</i></div>
          <h4 class="rich-title">{l s='Give us a call' d='Shop.Theme.Global'}</h4>
          <div class="data">
            <div class="call">
              {l s='Call:' d='Shop.Theme.Global'}
              <a href="tel:{$contact_infos.phone}">{$contact_infos.phone}</a>
            </div>
            <div class="fax">
              {l s='Fax:' d='Shop.Theme.Global'}
              <span>{$contact_infos.fax}</span>
            </div>
           </div>
        </div>
      {/if}
    </div>
    <div class="col-lg-4 col-md-4 col-sm-4 col-sp-12">
      {if $contact_infos.email}
        <div class="block">
          <div class="icon"><i class="material-icons">&#xE158;</i></div>
          <h4 class="rich-title">{l s='Connect Online' d='Shop.Theme.Global'}</h4>
          <div class="data email">
            <a href="mailto:{$contact_infos.email}">{$contact_infos.email}</a>
           </div>
        </div>
      {/if}
    </div>
  </div>
</div>
